/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.Ordering;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleCall;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.PartiallyOrderedSet;
import org.apache.calcite.util.Util;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(since="1.23", status=API.Status.INTERNAL)
class Dumpers {
    private Dumpers() {
    }

    static String provenance(Map<RelNode, VolcanoPlanner.Provenance> provenanceMap, RelNode root) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        final ArrayList nodes = new ArrayList();
        new RelVisitor(){

            @Override
            public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                nodes.add(node);
                super.visit(node, ordinal, parent);
            }
        }.go(root);
        HashSet<RelNode> visited = new HashSet<RelNode>();
        for (RelNode node : nodes) {
            Dumpers.provenanceRecurse(provenanceMap, pw, node, 0, visited);
        }
        pw.flush();
        return sw.toString();
    }

    private static void provenanceRecurse(Map<RelNode, VolcanoPlanner.Provenance> provenanceMap, PrintWriter pw, RelNode node, int i, Set<RelNode> visited) {
        Spaces.append((PrintWriter)pw, (int)(i * 2));
        if (!visited.add(node)) {
            pw.println("rel#" + node.getId() + " (see above)");
            return;
        }
        pw.println(node);
        VolcanoPlanner.Provenance o = provenanceMap.get(node);
        Spaces.append((PrintWriter)pw, (int)(i * 2 + 2));
        if (o == VolcanoPlanner.Provenance.EMPTY) {
            pw.println("no parent");
        } else if (o instanceof VolcanoPlanner.DirectProvenance) {
            RelNode rel = ((VolcanoPlanner.DirectProvenance)o).source;
            pw.println("direct");
            Dumpers.provenanceRecurse(provenanceMap, pw, rel, i + 2, visited);
        } else if (o instanceof VolcanoPlanner.RuleProvenance) {
            VolcanoPlanner.RuleProvenance rule = (VolcanoPlanner.RuleProvenance)o;
            pw.println("call#" + rule.callId + " rule [" + rule.rule + "]");
            for (RelNode rel : rule.rels) {
                Dumpers.provenanceRecurse(provenanceMap, pw, rel, i + 2, visited);
            }
        } else if (o == null && node instanceof RelSubset) {
            RelSubset subset = (RelSubset)node;
            pw.println("subset " + subset);
            Dumpers.provenanceRecurse(provenanceMap, pw, subset.getRelList().get(0), i + 2, visited);
        } else {
            throw new AssertionError((Object)("bad type " + o));
        }
    }

    static void dumpSets(VolcanoPlanner planner, PrintWriter pw) {
        Ordering ordering = Ordering.from(Comparator.comparingInt(o -> o.id));
        for (RelSet set : ordering.immutableSortedCopy(planner.allSets)) {
            pw.println("Set#" + set.id + ", type: " + set.subsets.get(0).getRowType());
            int j = -1;
            for (RelSubset subset : set.subsets) {
                ++j;
                pw.println("\t" + subset + ", best=" + (subset.best == null ? "null" : "rel#" + subset.best.getId()));
                assert (subset.set == set);
                for (int k = 0; k < j; ++k) {
                    assert (!set.subsets.get(k).getTraitSet().equals(subset.getTraitSet()));
                }
                for (RelNode rel : subset.getRels()) {
                    pw.print("\t\t" + rel);
                    for (RelNode input : rel.getInputs()) {
                        Iterator<RelNode> rels;
                        RelSubset inputSubset = planner.getSubset(input, input.getTraitSet());
                        if (inputSubset == null) {
                            pw.append("no subset found for input ").print(input.getId());
                            continue;
                        }
                        RelSet inputSet = inputSubset.set;
                        if (!(input instanceof RelSubset) || !(rels = inputSubset.getRels().iterator()).hasNext()) continue;
                        input = rels.next();
                        assert (input.getTraitSet().satisfies(inputSubset.getTraitSet()));
                        assert (inputSet.rels.contains(input));
                        assert (inputSet.subsets.contains(inputSubset));
                    }
                    if (planner.prunedNodes.contains(rel)) {
                        pw.print(", pruned");
                    }
                    RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
                    pw.print(", rowcount=" + mq.getRowCount(rel));
                    pw.println(", cumulative cost=" + planner.getCost(rel, mq));
                }
            }
        }
    }

    static void dumpGraphviz(VolcanoPlanner planner, PrintWriter pw) {
        Ordering ordering = Ordering.from(Comparator.comparingInt(o -> o.id));
        HashSet<RelNode> activeRels = new HashSet<RelNode>();
        for (VolcanoRuleCall volcanoRuleCall : planner.ruleCallStack) {
            activeRels.addAll(Arrays.asList(volcanoRuleCall.rels));
        }
        pw.println("digraph G {");
        pw.println("\troot [style=filled,label=\"Root\"];");
        PartiallyOrderedSet<RelSubset> subsetPoset = new PartiallyOrderedSet<RelSubset>((e1, e2) -> e1.getTraitSet().satisfies(e2.getTraitSet()));
        HashSet<Iterator<RelNode>> nonEmptySubsets = new HashSet<Iterator<RelNode>>();
        for (RelSet set : ordering.immutableSortedCopy(planner.allSets)) {
            pw.print("\tsubgraph cluster");
            pw.print(set.id);
            pw.println("{");
            pw.print("\t\tlabel=");
            Util.printJavaString(pw, "Set " + set.id + " " + set.subsets.get(0).getRowType(), false);
            pw.print(";\n");
            for (RelNode rel : set.rels) {
                int openParen;
                pw.print("\t\trel");
                pw.print(rel.getId());
                pw.print(" [label=");
                RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
                Iterator<RelNode> relSubset = planner.getSubset(rel);
                if (relSubset == null) {
                    pw.append("no subset found for rel");
                    continue;
                }
                String traits = "." + ((AbstractRelNode)((Object)relSubset)).getTraitSet().toString();
                String title = rel.toString().replace(traits, "");
                if (title.endsWith(")") && (openParen = title.indexOf(40)) != -1) {
                    title = title.substring(0, openParen) + '\n' + title.substring(openParen + 1, title.length() - 1);
                }
                Util.printJavaString(pw, title + "\nrows=" + mq.getRowCount(rel) + ", cost=" + planner.getCost(rel, mq), false);
                if (!(rel instanceof AbstractConverter)) {
                    nonEmptySubsets.add(relSubset);
                }
                if (((RelSubset)((Object)relSubset)).best == rel) {
                    pw.print(",color=blue");
                }
                if (activeRels.contains(rel)) {
                    pw.print(",style=dashed");
                }
                pw.print(",shape=box");
                pw.println("]");
            }
            subsetPoset.clear();
            for (RelSubset subset : set.subsets) {
                boolean empty;
                subsetPoset.add(subset);
                pw.print("\t\tsubset");
                pw.print(subset.getId());
                pw.print(" [label=");
                Util.printJavaString(pw, subset.toString(), false);
                boolean bl = empty = !nonEmptySubsets.contains(subset);
                if (empty) {
                    for (RelNode rel : subset.getRels()) {
                        if (rel instanceof AbstractConverter) continue;
                        empty = false;
                        break;
                    }
                    if (empty) {
                        pw.print(",color=red");
                    }
                }
                if (activeRels.contains(subset)) {
                    pw.print(",style=dashed");
                }
                pw.print("]\n");
            }
            for (RelSubset subset : subsetPoset) {
                List<RelSubset> children = subsetPoset.getChildren(subset);
                if (children == null) continue;
                for (RelSubset parent : children) {
                    pw.print("\t\tsubset");
                    pw.print(subset.getId());
                    pw.print(" -> subset");
                    pw.print(parent.getId());
                    pw.print(";");
                }
            }
            pw.print("\t}\n");
        }
        pw.print("\troot -> subset");
        pw.print(Objects.requireNonNull(planner.root, "planner.root").getId());
        pw.println(";");
        for (RelSet set : ordering.immutableSortedCopy(planner.allSets)) {
            for (RelNode rel : set.rels) {
                RelSubset relSubset = planner.getSubset(rel);
                if (relSubset == null) {
                    pw.append("no subset found for rel ").print(rel.getId());
                    continue;
                }
                pw.print("\tsubset");
                pw.print(relSubset.getId());
                pw.print(" -> rel");
                pw.print(rel.getId());
                if (relSubset.best == rel) {
                    pw.print("[color=blue]");
                }
                pw.print(";");
                List<RelNode> inputs = rel.getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    RelNode input = inputs.get(i);
                    pw.print(" rel");
                    pw.print(rel.getId());
                    pw.print(" -> ");
                    pw.print(input instanceof RelSubset ? "subset" : "rel");
                    pw.print(input.getId());
                    if (relSubset.best == rel || inputs.size() > 1) {
                        int sep = 91;
                        if (relSubset.best == rel) {
                            pw.print((char)sep);
                            pw.print("color=blue");
                            sep = 44;
                        }
                        if (inputs.size() > 1) {
                            pw.print((char)sep);
                            pw.print("label=\"");
                            pw.print(i);
                            pw.print("\"");
                        }
                        pw.print(']');
                    }
                    pw.print(";");
                }
                pw.println();
            }
        }
        for (VolcanoRuleCall ruleCall : planner.ruleCallStack) {
            pw.print("rule");
            pw.print(ruleCall.id);
            pw.print(" [style=dashed,label=");
            Util.printJavaString(pw, ruleCall.rule.toString(), false);
            pw.print("]");
            RelNode[] rels = ruleCall.rels;
            for (int i = 0; i < rels.length; ++i) {
                RelNode rel = rels[i];
                pw.print(" rule");
                pw.print(ruleCall.id);
                pw.print(" -> ");
                pw.print(rel instanceof RelSubset ? "subset" : "rel");
                pw.print(rel.getId());
                pw.print(" [style=dashed");
                if (rels.length > 1) {
                    pw.print(",label=\"");
                    pw.print(i);
                    pw.print("\"");
                }
                pw.print("]");
                pw.print(";");
            }
            pw.println();
        }
        pw.print("}");
    }
}

