/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ScopedHandler;

public class RequestUpdateHandler
extends ScopedHandler {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private String redirectContext;

    public RequestUpdateHandler(GatewayConfig config, String topologyName, GatewayServices services) {
        if (config == null) {
            throw new IllegalArgumentException("config==null");
        }
        if (services == null) {
            throw new IllegalArgumentException("services==null");
        }
        if (topologyName == null) {
            throw new IllegalArgumentException("topologyName==null");
        }
        this.redirectContext = "/" + config.getGatewayPath() + "/" + topologyName;
    }

    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.nextScope(target, baseRequest, request, response);
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String newTarget = this.redirectContext + target;
        ForwardedRequest newRequest = new ForwardedRequest(request, this.redirectContext, newTarget);
        if (!StringUtils.startsWithIgnoreCase((CharSequence)target, (CharSequence)this.redirectContext)) {
            baseRequest.setPathInfo(this.redirectContext + baseRequest.getPathInfo());
            baseRequest.setURIPathQuery(this.redirectContext + baseRequest.getRequestURI());
            LOG.topologyPortMappingUpdateRequest(target, newTarget);
            this.nextHandle(newTarget, baseRequest, (HttpServletRequest)newRequest, response);
        } else {
            this.nextHandle(target, baseRequest, (HttpServletRequest)newRequest, response);
        }
    }

    static class ForwardedRequest
    extends HttpServletRequestWrapper {
        private String newURL;
        private String contextpath;

        ForwardedRequest(HttpServletRequest request, String contextpath, String newURL) {
            super(request);
            this.newURL = newURL;
            this.contextpath = contextpath;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.newURL);
        }

        public String getRequestURI() {
            return this.contextpath + super.getRequestURI();
        }

        public String getContextPath() {
            return this.contextpath;
        }
    }
}

