/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support;

import org.apache.karaf.shell.api.console.Session;

public class NameScoping {
    public static final String MULTI_SCOPE_MODE_KEY = "MULTI_SCOPE_MODE";

    public static String getCommandNameWithoutGlobalPrefix(Session session, String key) {
        String prefix;
        String globalScope;
        if (!NameScoping.isMultiScopeMode(session) && (globalScope = (String)(session != null ? session.get("APPLICATION") : null)) != null && key.startsWith(prefix = globalScope + ":")) {
            return key.substring(prefix.length());
        }
        return key;
    }

    public static boolean isGlobalScope(Session session, String scope) {
        String globalScope;
        if (session == null) {
            return false;
        }
        if (!NameScoping.isMultiScopeMode(session) && (globalScope = (String)session.get("APPLICATION")) != null) {
            return scope.equals(globalScope);
        }
        return false;
    }

    public static boolean isMultiScopeMode(Session session) {
        if (session == null) {
            return false;
        }
        Object value = session.get(MULTI_SCOPE_MODE_KEY);
        return value == null || !value.equals("false");
    }
}

