/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.aries.util.IORuntimeException;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.FileSystemImpl;
import org.apache.aries.util.filesystem.impl.NestedZipDirectory;
import org.apache.aries.util.filesystem.impl.ZipCloseableDirectory;
import org.apache.aries.util.filesystem.impl.ZipDirectory;

public class ZipFileImpl
implements IFile {
    private String name;
    private final long size;
    private final long lastModified;
    protected final File zip;
    protected final ZipEntry entry;
    private final IDirectory parent;
    private final String url;
    private final String zipPathToRoot;
    protected final ZipCloseableDirectory cache;

    public ZipFileImpl(File zip1, ZipEntry entry1, ZipDirectory parent1, ZipCloseableDirectory cache) {
        this.zip = zip1;
        this.entry = entry1;
        this.zipPathToRoot = parent1.getZipPathToRoot();
        this.name = this.zipPathToRoot + entry1.getName();
        if (entry1.isDirectory()) {
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        this.lastModified = entry1.getTime();
        this.size = entry1.getSize();
        this.url = parent1.url;
        this.parent = parent1;
        this.cache = cache;
    }

    protected ZipFileImpl(File zip1, IDirectory parent) throws MalformedURLException {
        this.zip = zip1;
        this.entry = null;
        if (parent == null) {
            this.name = "";
            this.zipPathToRoot = "";
            this.parent = null;
        } else {
            this.parent = parent;
            this.name = parent.getName() + "/" + zip1.getName();
            this.zipPathToRoot = this.name + "/";
        }
        this.lastModified = zip1.lastModified();
        this.size = zip1.length();
        this.url = zip1.toURI().toURL().toExternalForm();
        this.cache = null;
    }

    public ZipFileImpl(ZipFileImpl other, ZipCloseableDirectory cache) {
        this.name = other.name;
        this.size = other.size;
        this.lastModified = other.lastModified;
        this.zip = other.zip;
        this.entry = other.entry;
        this.parent = other.parent;
        this.url = other.url;
        this.zipPathToRoot = other.zipPathToRoot;
        this.cache = cache;
    }

    public String getZipPathToRoot() {
        return this.zipPathToRoot;
    }

    @Override
    public IDirectory convert() {
        return null;
    }

    @Override
    public IDirectory convertNested() {
        if (this.isDirectory()) {
            return this.convert();
        }
        if (FileSystemImpl.isValidZip(this)) {
            return new NestedZipDirectory(this);
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNameInZip() {
        if (this.entry == null) {
            return "";
        }
        String name = this.entry.getName();
        if (this.isDirectory()) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public IDirectory getParent() {
        return this.parent;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public InputStream open() throws IOException {
        SpecialZipInputStream is = new SpecialZipInputStream(this.entry);
        return is;
    }

    @Override
    public IDirectory getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        URL result;
        if (this.name.equals(this.zipPathToRoot)) {
            result = new URL(this.url);
        } else {
            String entryURL = "jar:" + this.url + "!/";
            entryURL = this.entry != null ? entryURL + this.entry.getName() : entryURL + this.name.substring(this.zipPathToRoot.length());
            result = new URL(entryURL);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.name != null && this.name.length() != 0) {
            return this.url.substring(5) + "/" + this.name;
        }
        return this.url.substring(5);
    }

    ZipFile openZipFile() {
        ZipFile z = null;
        if (this.cache != null && !this.cache.isClosed()) {
            z = this.cache.getZipFile();
        } else {
            try {
                z = new ZipFile(this.zip);
            }
            catch (IOException e) {
                throw new IORuntimeException("IOException in ZipFileImpl.openZipFile", e);
            }
        }
        return z;
    }

    void closeZipFile(ZipFile z) {
        if (this.cache == null || this.cache.getZipFile() != z) {
            try {
                z.close();
            }
            catch (IOException e) {
                throw new IORuntimeException("IOException in ZipFileImpl.closeZipFile", e);
            }
        }
    }

    private class SpecialZipInputStream
    extends InputStream {
        private ZipFile zipFile;
        private InputStream is;

        public SpecialZipInputStream(ZipEntry anEntry) {
            try {
                this.zipFile = ZipFileImpl.this.openZipFile();
                this.is = this.zipFile.getInputStream(anEntry);
            }
            catch (ZipException e) {
                throw new IORuntimeException("ZipException in SpecialZipInputStream()", e);
            }
            catch (IOException e) {
                throw new IORuntimeException("IOException in SpecialZipInputStream()", e);
            }
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
            ZipFileImpl.this.closeZipFile(this.zipFile);
        }
    }
}

