/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.util.Locale;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class PointRangeQueryBuilder
implements QueryBuilder {
    @Override
    public Query getQuery(Element e2) throws ParserException {
        String field = DOMUtils.getAttributeWithInheritanceOrFail(e2, "fieldName");
        String lowerTerm = DOMUtils.getAttribute(e2, "lowerTerm", null);
        String upperTerm = DOMUtils.getAttribute(e2, "upperTerm", null);
        String type = DOMUtils.getAttribute(e2, "type", "int").toLowerCase(Locale.getDefault());
        try {
            return switch (type) {
                case "int" -> IntPoint.newRangeQuery(field, lowerTerm == null ? Integer.MIN_VALUE : Integer.parseInt(lowerTerm), upperTerm == null ? Integer.MAX_VALUE : Integer.parseInt(upperTerm));
                case "long" -> LongPoint.newRangeQuery(field, lowerTerm == null ? Long.MIN_VALUE : Long.parseLong(lowerTerm), upperTerm == null ? Long.MAX_VALUE : Long.parseLong(upperTerm));
                case "double" -> DoublePoint.newRangeQuery(field, lowerTerm == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerTerm), upperTerm == null ? Double.POSITIVE_INFINITY : Double.parseDouble(upperTerm));
                case "float" -> FloatPoint.newRangeQuery(field, lowerTerm == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerTerm), upperTerm == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperTerm));
                default -> throw new ParserException("type attribute must be one of: [long, int, double, float]");
            };
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse lowerTerm or upperTerm into a number", nfe);
        }
    }
}

