/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.api.CompactionApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.jsonld.JenaToTitanium;
import org.apache.jena.riot.system.jsonld.TitaniumJsonLdOptions;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class JsonLD11Writer
implements WriterDatasetRIOT {
    private static Map<String, ?> configIndented = Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    private static Map<String, ?> configFlat = Map.of();
    private final RDFFormat format;

    public JsonLD11Writer(RDFFormat format) {
        this.format = format;
    }

    @Override
    public void write(OutputStream outputStream, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(datasetGraph);
        this.write$(outputStream, null, datasetGraph, baseURI, context2);
    }

    @Override
    public void write(Writer out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(datasetGraph);
        this.write$(null, out, datasetGraph, baseURI, context2);
    }

    @Override
    public Lang getLang() {
        return this.format.getLang();
    }

    private void write$(OutputStream output, Writer writer, DatasetGraph dsg, String baseURI, Context context2) {
        try {
            JsonStructure writeThis;
            JsonLdOptions opts = TitaniumJsonLdOptions.get(baseURI, context2);
            JsonArray array = JenaToTitanium.convert(dsg, opts);
            RDFFormatVariant variant = this.format.getVariant();
            boolean indented = true;
            if (Lib.equalsOrNulls(variant, RDFFormat.PRETTY)) {
                writeThis = this.writePretty(array, dsg);
            } else if (variant == null || Lib.equalsOrNulls(variant, RDFFormat.PLAIN)) {
                writeThis = this.writePlain(array, dsg);
            } else if (Lib.equalsOrNulls(variant, RDFFormat.FLAT)) {
                writeThis = this.writePlain(array, dsg);
                indented = false;
            } else {
                writeThis = this.writePretty(array, dsg);
            }
            if (writeThis == null) {
                FmtLog.error(this.getClass(), "Nothing to write", new Object[0]);
                return;
            }
            if (!(writeThis instanceof JsonObject)) {
                FmtLog.warn(this.getClass(), "Output is not a JSON object (%s)", writeThis.getClass().getSimpleName());
            }
            this.writeJson(writeThis, output, writer, indented);
        }
        catch (Throwable ex) {
            throw new JenaException("Exception while writing JSON-LD 1.1", ex);
        }
    }

    private Map<String, ?> config(boolean indented) {
        return indented ? configIndented : configFlat;
    }

    private JsonStructure writePlain(JsonArray array, DatasetGraph dsg) throws JsonLdError {
        JsonObject writeRdf = Json.createObjectBuilder().add("@graph", array).build();
        return writeRdf;
    }

    private JsonStructure writePretty(JsonArray array, DatasetGraph dsg) throws JsonLdError {
        JsonLdOptions options = new JsonLdOptions();
        JsonObjectBuilder cxt = Json.createObjectBuilder();
        dsg.prefixes().forEach((k, v) -> {
            if (!k.isEmpty()) {
                cxt.add((String)k, (String)v);
            }
        });
        String vocab = dsg.prefixes().get("");
        if (vocab != null) {
            cxt.add("@vocab", vocab);
        }
        JsonObject context2 = cxt.build();
        JsonObject writeRdf = Json.createObjectBuilder().add("@context", context2).add("@graph", array).build();
        JsonDocument contextDoc = JsonDocument.of(context2);
        CompactionApi api = JsonLd.compact((Document)JsonDocument.of(writeRdf), (Document)contextDoc);
        api.rdfStar();
        JsonObject x = api.get();
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJson(JsonStructure json2, OutputStream output, Writer writer, boolean indented) throws IOException {
        JsonWriter jw = this.startWrite(output, writer, true);
        try {
            jw.write(json2);
        }
        finally {
            this.finishWrite(output, writer, true);
        }
    }

    private JsonWriter startWrite(OutputStream output, Writer writer, boolean indented) {
        Map<String, ?> config = this.config(indented);
        JsonWriterFactory factory = Json.createWriterFactory(config);
        return output != null ? factory.createWriter(output) : factory.createWriter(writer);
    }

    private void finishWrite(OutputStream output, Writer writer, boolean indented) throws IOException {
        boolean outputNL = indented;
        if (output != null) {
            if (outputNL) {
                output.write(10);
            }
            output.flush();
        } else {
            if (outputNL) {
                writer.write("\n");
            }
            writer.flush();
        }
    }
}

