/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.expression.impl;

import java.io.Serializable;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SingleSeriesExpression
implements IUnaryExpression,
Serializable {
    private static final long serialVersionUID = 7131207370394865228L;
    private Path seriesPath;
    private Filter filter;

    public SingleSeriesExpression(Path seriesDescriptor, Filter filter) {
        this.seriesPath = seriesDescriptor;
        this.filter = filter;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.SERIES;
    }

    @Override
    public IExpression clone() {
        return new SingleSeriesExpression(this.seriesPath.clone(), this.filter.copy());
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String toString() {
        return "[" + this.seriesPath + ":" + this.filter + "]";
    }

    public Path getSeriesPath() {
        return this.seriesPath;
    }

    public void setSeriesPath(Path seriesPath) {
        this.seriesPath = seriesPath;
    }
}

