/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.db.query.udf.builtin.UDTFValueDifference;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFCommonValueDifference
extends UDTFValueDifference {
    @Override
    protected void doTransform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                int currentInt = row.getInt(0);
                collector.putInt(time, currentInt - this.previousInt);
                this.previousInt = currentInt;
                break;
            }
            case INT64: {
                long currentLong = row.getLong(0);
                collector.putLong(time, currentLong - this.previousLong);
                this.previousLong = currentLong;
                break;
            }
            case FLOAT: {
                float currentFloat = row.getFloat(0);
                collector.putFloat(time, currentFloat - this.previousFloat);
                this.previousFloat = currentFloat;
                break;
            }
            case DOUBLE: {
                double currentDouble = row.getDouble(0);
                collector.putDouble(time, currentDouble - this.previousDouble);
                this.previousDouble = currentDouble;
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            }
        }
    }
}

