/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.archiving;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.iotdb.db.engine.archiving.ArchivingOperate;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivingOperateReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ArchivingOperateReader.class);
    private final File logFile;
    private FileInputStream logFileInStream;
    private ArchivingOperate operate;
    private long unbrokenLogsSize = 0L;

    public ArchivingOperateReader(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.logFileInStream = new FileInputStream(this.logFile);
    }

    public ArchivingOperateReader(File logFile) throws IOException {
        this.logFile = logFile;
        this.logFileInStream = new FileInputStream(logFile);
    }

    private ArchivingOperate readOperate() {
        try {
            ArchivingOperate log = ArchivingOperate.deserialize(this.logFileInStream);
            this.unbrokenLogsSize = this.logFileInStream.getChannel().position();
            return log;
        }
        catch (IOException | IllegalPathException e) {
            return null;
        }
    }

    public ArchivingOperate next() {
        ArchivingOperate ret = this.operate;
        this.operate = null;
        return ret;
    }

    public boolean hasNext() {
        if (this.operate != null) {
            return true;
        }
        this.operate = this.readOperate();
        if (this.operate == null) {
            this.truncateBrokenLogs();
            this.operate = null;
            return false;
        }
        return true;
    }

    private void truncateBrokenLogs() {
        try (FileOutputStream outputStream = new FileOutputStream(this.logFile, true);
             FileChannel channel = outputStream.getChannel();){
            channel.truncate(this.unbrokenLogsSize);
        }
        catch (IOException e) {
            logger.error("Fail to truncate log file to size {}", (Object)this.unbrokenLogsSize, (Object)e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.logFileInStream.close();
        }
        catch (IOException e) {
            logger.error("Failed to close archiving log");
        }
    }
}

