/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.PublicAccessType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="BlobContainerItemProperties")
public final class BlobContainerItemProperties {
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String eTag;
    @JsonProperty(value="LeaseStatus")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="LeaseState")
    private LeaseStateType leaseState;
    @JsonProperty(value="LeaseDuration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="PublicAccess")
    private PublicAccessType publicAccess;
    @JsonProperty(value="HasImmutabilityPolicy")
    private Boolean hasImmutabilityPolicy;
    @JsonProperty(value="HasLegalHold")
    private Boolean hasLegalHold;
    @JsonProperty(value="DefaultEncryptionScope")
    private String defaultEncryptionScope;
    @JsonProperty(value="DenyEncryptionScopeOverride")
    private Boolean encryptionScopeOverridePrevented;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobContainerItemProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobContainerItemProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobContainerItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobContainerItemProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobContainerItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public PublicAccessType getPublicAccess() {
        return this.publicAccess;
    }

    public BlobContainerItemProperties setPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public Boolean isHasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public BlobContainerItemProperties setHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    public Boolean isHasLegalHold() {
        return this.hasLegalHold;
    }

    public BlobContainerItemProperties setHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }

    public String getDefaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public BlobContainerItemProperties setDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    public boolean isEncryptionScopeOverridePrevented() {
        Boolean returnValue = this.encryptionScopeOverridePrevented;
        return Boolean.TRUE.equals(returnValue);
    }

    public BlobContainerItemProperties setEncryptionScopeOverridePrevented(boolean encryptionScopeOverridePrevented) {
        this.encryptionScopeOverridePrevented = encryptionScopeOverridePrevented;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobContainerItemProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobContainerItemProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }
}

