/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.basic;

import java.util.Arrays;
import org.apache.ignite.internal.storage.DataRow;
import org.apache.ignite.internal.storage.InvokeClosure;
import org.apache.ignite.internal.storage.OperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteExactInvokeClosure
implements InvokeClosure<Boolean> {
    @NotNull
    private final DataRow row;
    private boolean deletes = false;

    public DeleteExactInvokeClosure(@NotNull DataRow row) {
        this.row = row;
    }

    @Override
    public void call(@Nullable DataRow row) {
        this.deletes = row != null && Arrays.equals(this.row.valueBytes(), row.valueBytes());
    }

    @Override
    @Nullable
    public DataRow newRow() {
        return null;
    }

    @Override
    @Nullable
    public OperationType operationType() {
        return this.deletes ? OperationType.REMOVE : OperationType.NOOP;
    }

    @Override
    @NotNull
    public Boolean result() {
        return this.deletes;
    }
}

