/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.reflection.ColumnBinding;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.util.Factory;
import org.apache.ignite.internal.util.ObjectFactory;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.mapper.OneColumnMapper;
import org.apache.ignite.table.mapper.PojoMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Marshaller {
    public static <T> Marshaller createMarshaller(Column[] cols, @NotNull Mapper<T> mapper, boolean requireAllFields) {
        if (mapper instanceof OneColumnMapper) {
            return Marshaller.simpleMarshaller(cols, (OneColumnMapper)mapper);
        }
        if (mapper instanceof PojoMapper) {
            return Marshaller.pojoMarshaller(cols, (PojoMapper)mapper, requireAllFields);
        }
        throw new IllegalArgumentException("Mapper of unsupported type: " + mapper.getClass());
    }

    static <T> SimpleMarshaller simpleMarshaller(Column[] cols, @NotNull OneColumnMapper<T> mapper) {
        Column col;
        Class targetType = mapper.targetType();
        Column column = col = mapper.mappedColumn() == null && cols.length == 1 ? cols[0] : Arrays.stream(cols).filter(c -> c.name().equals(mapper.mappedColumn())).findFirst().orElseThrow(() -> new SchemaMismatchException("Failed to map object to a single column:" + mapper.mappedColumn()));
        assert (!targetType.isPrimitive()) : "Non-nullable types are not allowed.";
        return new SimpleMarshaller(ColumnBinding.createIdentityBinding(col, targetType, mapper.converter()));
    }

    static <T> ObjectMarshaller pojoMarshaller(Column[] cols, @NotNull PojoMapper<T> mapper, boolean requireAllFields) {
        Class targetType = mapper.targetType();
        ColumnBinding[] columnBindings = new ColumnBinding[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            String fieldName = mapper.fieldForColumn(col.name());
            if (fieldName == null) {
                if (requireAllFields) {
                    throw new IllegalArgumentException("No field found for column " + col.name());
                }
                columnBindings[i] = ColumnBinding.unmappedFieldBinding(col);
                continue;
            }
            columnBindings[i] = ColumnBinding.createFieldBinding(col, targetType, fieldName, mapper.converterForColumn(col.name()));
        }
        return new ObjectMarshaller(new ObjectFactory(targetType), columnBindings);
    }

    @Nullable
    public abstract Object value(Object var1, int var2) throws MarshallerException;

    public abstract Object readObject(Row var1) throws MarshallerException;

    public abstract void writeObject(Object var1, RowAssembler var2) throws MarshallerException;

    static class ObjectMarshaller
    extends Marshaller {
        private final ColumnBinding[] columnBindings;
        private final Factory<?> factory;

        ObjectMarshaller(Factory<?> factory, ColumnBinding[] columnBindings) {
            this.columnBindings = columnBindings;
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) throws MarshallerException {
            return this.columnBindings[fldIdx].value(obj);
        }

        @Override
        public Object readObject(Row reader) throws MarshallerException {
            try {
                Object obj = this.factory.create();
                for (int fldIdx = 0; fldIdx < this.columnBindings.length; ++fldIdx) {
                    this.columnBindings[fldIdx].read(reader, obj);
                }
                return obj;
            }
            catch (MarshallerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new MarshallerException("Failed to read row. ", e);
            }
        }

        @Override
        public void writeObject(Object obj, RowAssembler writer) throws MarshallerException {
            try {
                for (int fldIdx = 0; fldIdx < this.columnBindings.length; ++fldIdx) {
                    this.columnBindings[fldIdx].write(writer, obj);
                }
            }
            catch (MarshallerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new MarshallerException("Failed to write row. ", e);
            }
        }
    }

    static class SimpleMarshaller
    extends Marshaller {
        private final ColumnBinding columnBinding;

        SimpleMarshaller(ColumnBinding columnBinding) {
            this.columnBinding = columnBinding;
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) throws MarshallerException {
            assert (fldIdx == 0);
            return this.columnBinding.value(obj);
        }

        @Override
        public Object readObject(Row reader) throws MarshallerException {
            try {
                return this.columnBinding.columnValue(reader);
            }
            catch (Throwable e) {
                throw new MarshallerException("Failed to read column: colIdx" + this.columnBinding.colIdx, e);
            }
        }

        @Override
        public void writeObject(Object obj, RowAssembler writer) throws MarshallerException {
            try {
                this.columnBinding.write(writer, obj);
            }
            catch (Throwable e) {
                throw new MarshallerException("Failed to write column: colIdx" + this.columnBinding.colIdx, e);
            }
        }
    }
}

