/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.table.distributed.TableMessageGroup;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotMetaRequest;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotMvDataRequest;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotRequestMessage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotTxDataRequest;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.jetbrains.annotations.Nullable;

public class OutgoingSnapshotsManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(OutgoingSnapshotsManager.class);
    private final MessagingService messagingService;
    private final ConcurrentMap<UUID, OutgoingSnapshot> outgoingSnapshots = new ConcurrentHashMap<UUID, OutgoingSnapshot>();

    public OutgoingSnapshotsManager(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public MessagingService messagingService() {
        return this.messagingService;
    }

    public void start() {
        this.messagingService.addMessageHandler(TableMessageGroup.class, this::messageHandler);
    }

    public void stop() throws Exception {
    }

    void registerOutgoingSnapshot(UUID snapshotId, OutgoingSnapshot outgoingSnapshot) {
        this.outgoingSnapshots.put(snapshotId, outgoingSnapshot);
    }

    void finishOutgoingSnapshot(UUID snapshotId) {
        this.outgoingSnapshots.remove(snapshotId);
    }

    private void messageHandler(NetworkMessage networkMessage, NetworkAddress sender, @Nullable Long correlationId) {
        if (!(networkMessage instanceof SnapshotRequestMessage)) {
            return;
        }
        assert (correlationId != null);
        OutgoingSnapshot outgoingSnapshot = (OutgoingSnapshot)this.outgoingSnapshots.get(((SnapshotRequestMessage)networkMessage).id());
        if (outgoingSnapshot == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unexpected snapshot request message has been received [message={}]", new Object[]{networkMessage});
            }
            return;
        }
        CompletableFuture<? extends NetworkMessage> responseFuture = OutgoingSnapshotsManager.handleSnapshotRequestMessage(networkMessage, outgoingSnapshot);
        if (responseFuture != null) {
            responseFuture.whenComplete((response, throwable) -> this.respond((NetworkMessage)response, (Throwable)throwable, sender, correlationId));
        }
    }

    @Nullable
    private static CompletableFuture<? extends NetworkMessage> handleSnapshotRequestMessage(NetworkMessage networkMessage, OutgoingSnapshot outgoingSnapshot) {
        switch (networkMessage.messageType()) {
            case 10: {
                return outgoingSnapshot.handleSnapshotMetaRequest((SnapshotMetaRequest)networkMessage);
            }
            case 12: {
                return outgoingSnapshot.handleSnapshotMvDataRequest((SnapshotMvDataRequest)networkMessage);
            }
            case 15: {
                return outgoingSnapshot.handleSnapshotTxDataRequest((SnapshotTxDataRequest)networkMessage);
            }
        }
        return null;
    }

    private CompletableFuture<Void> respond(NetworkMessage response, Throwable throwable, NetworkAddress sender, Long correlationId) {
        return this.messagingService.respond(sender, response, correlationId.longValue());
    }
}

