/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.IndexRowImpl;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.util.Cursor;

public class TableSchemaAwareIndexStorage {
    private final UUID indexId;
    private final IndexStorage storage;
    private final Function<BinaryRow, BinaryTuple> indexRowResolver;

    public TableSchemaAwareIndexStorage(UUID indexId, IndexStorage storage, Function<BinaryRow, BinaryTuple> indexRowResolver) {
        this.indexId = indexId;
        this.storage = storage;
        this.indexRowResolver = indexRowResolver;
    }

    public UUID id() {
        return this.indexId;
    }

    public Cursor<RowId> get(BinaryRow tableRow) throws StorageException {
        BinaryTuple tuple = this.indexRowResolver.apply(tableRow);
        return this.storage.get(tuple);
    }

    public void put(BinaryRow tableRow, RowId rowId) {
        BinaryTuple tuple = this.indexRowResolver.apply(tableRow);
        this.storage.put((IndexRow)new IndexRowImpl(tuple, rowId));
    }

    public void remove(BinaryRow tableRow, RowId rowId) {
        BinaryTuple tuple = this.indexRowResolver.apply(tableRow);
        this.storage.remove((IndexRow)new IndexRowImpl(tuple, rowId));
    }

    public IndexStorage storage() {
        return this.storage;
    }
}

