/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.ReadCommand;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.ActionRequest;
import org.apache.ignite.raft.jraft.rpc.ActionResponse;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.RaftException;
import org.apache.ignite.raft.jraft.rpc.impl.SMCompactedThrowable;
import org.apache.ignite.raft.jraft.rpc.impl.SMFullThrowable;
import org.apache.ignite.raft.jraft.rpc.impl.SMThrowable;
import org.jetbrains.annotations.NotNull;

public class RaftGroupServiceImpl
implements RaftGroupService {
    private static final IgniteLogger LOG = Loggers.forClass(RaftGroupServiceImpl.class);
    private volatile long timeout;
    private final long rpcTimeout;
    private final String groupId;
    private final ReplicationGroupId realGroupId;
    private final RaftMessagesFactory factory;
    private volatile Peer leader;
    private volatile List<Peer> peers;
    private volatile List<Peer> learners;
    private final ClusterService cluster;
    private final long retryDelay;
    private final ScheduledExecutorService executor;

    private RaftGroupServiceImpl(ReplicationGroupId groupId, ClusterService cluster, RaftMessagesFactory factory, int timeout, int rpcTimeout, List<Peer> peers, Peer leader, long retryDelay, ScheduledExecutorService executor) {
        this.cluster = Objects.requireNonNull(cluster);
        this.peers = Objects.requireNonNull(peers);
        this.learners = Collections.emptyList();
        this.factory = factory;
        this.timeout = timeout;
        this.rpcTimeout = rpcTimeout;
        this.groupId = groupId.toString();
        this.realGroupId = groupId;
        this.retryDelay = retryDelay;
        this.leader = leader;
        this.executor = executor;
    }

    public static CompletableFuture<RaftGroupService> start(ReplicationGroupId groupId, ClusterService cluster, RaftMessagesFactory factory, int timeout, int rpcTimeout, List<Peer> peers, boolean getLeader, long retryDelay, ScheduledExecutorService executor) {
        RaftGroupServiceImpl service = new RaftGroupServiceImpl(groupId, cluster, factory, timeout, rpcTimeout, peers, null, retryDelay, executor);
        if (!getLeader) {
            return CompletableFuture.completedFuture(service);
        }
        return service.refreshLeader().handle((unused, throwable) -> {
            if (throwable != null) {
                if (throwable.getCause() instanceof TimeoutException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to refresh a leader [groupId={}]", new Object[]{groupId});
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to refresh a leader [groupId={}]", throwable, new Object[]{groupId});
                }
            }
            return service;
        });
    }

    public static CompletableFuture<RaftGroupService> start(ReplicationGroupId groupId, ClusterService cluster, RaftMessagesFactory factory, int timeout, List<Peer> peers, boolean getLeader, long retryDelay, ScheduledExecutorService executor) {
        return RaftGroupServiceImpl.start(groupId, cluster, factory, timeout, timeout, peers, getLeader, retryDelay, executor);
    }

    @NotNull
    public ReplicationGroupId groupId() {
        return this.realGroupId;
    }

    public long timeout() {
        return this.timeout;
    }

    public void timeout(long newTimeout) {
        this.timeout = newTimeout;
    }

    public Peer leader() {
        return this.leader;
    }

    public List<Peer> peers() {
        return this.peers;
    }

    public List<Peer> learners() {
        return this.learners;
    }

    public CompletableFuture<Void> refreshLeader() {
        CliRequests.GetLeaderRequest req = this.factory.getLeaderRequest().groupId(this.groupId).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(this.randomNode(), req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.leader = RaftGroupServiceImpl.parsePeer(resp.leaderId());
            return null;
        });
    }

    public CompletableFuture<IgniteBiTuple<Peer, Long>> refreshAndGetLeaderWithTerm() {
        CliRequests.GetLeaderRequest req = this.factory.getLeaderRequest().groupId(this.groupId).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(this.randomNode(), req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            Peer respLeader;
            this.leader = respLeader = RaftGroupServiceImpl.parsePeer(resp.leaderId());
            return new IgniteBiTuple((Object)respLeader, (Object)resp.currentTerm());
        });
    }

    public CompletableFuture<Void> refreshMembers(boolean onlyAlive) {
        CliRequests.GetPeersRequest req = this.factory.getPeersRequest().onlyAlive(onlyAlive).groupId(this.groupId).build();
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.refreshMembers(onlyAlive));
        }
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.peers = this.parsePeerList(resp.peersList());
            this.learners = this.parsePeerList(resp.learnersList());
            return null;
        });
    }

    public CompletableFuture<Void> addPeer(Peer peer) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.addPeer(peer));
        }
        CliRequests.AddPeerRequest req = this.factory.addPeerRequest().groupId(this.groupId).peerId(PeerId.fromPeer(peer).toString()).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.peers = this.parsePeerList(resp.newPeersList());
            return null;
        });
    }

    public CompletableFuture<Void> removePeer(Peer peer) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.removePeer(peer));
        }
        CliRequests.RemovePeerRequest req = this.factory.removePeerRequest().groupId(this.groupId).peerId(PeerId.fromPeer(peer).toString()).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.peers = this.parsePeerList(resp.newPeersList());
            return null;
        });
    }

    public CompletableFuture<Void> changePeers(List<Peer> peers) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.changePeers(peers));
        }
        List<String> peersToChange = peers.stream().map(p -> PeerId.fromPeer(p).toString()).collect(Collectors.toList());
        CliRequests.ChangePeersRequest req = this.factory.changePeersRequest().groupId(this.groupId).newPeersList(peersToChange).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.peers = this.parsePeerList(resp.newPeersList());
            return null;
        });
    }

    public CompletableFuture<Void> changePeersAsync(List<Peer> peers, long term) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.changePeersAsync(peers, term));
        }
        List<String> peersToChange = peers.stream().map(p -> PeerId.fromPeer(p).toString()).collect(Collectors.toList());
        CliRequests.ChangePeersAsyncRequest req = this.factory.changePeersAsyncRequest().groupId(this.groupId).term(term).newPeersList(peersToChange).build();
        CompletableFuture fut = new CompletableFuture();
        LOG.info("Sending changePeersAsync request for group={} to peers={} with leader term={}", new Object[]{this.groupId, peers, term});
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return ((CompletableFuture)fut.handle((resp, err) -> {
            assert (!(resp instanceof RpcRequests.ErrorResponse));
            if (err != null) {
                return CompletableFuture.failedFuture(err);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(Function.identity());
    }

    public CompletableFuture<Void> addLearners(List<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.addLearners(learners));
        }
        List<String> lrns = learners.stream().map(p -> PeerId.fromPeer(p).toString()).collect(Collectors.toList());
        CliRequests.AddLearnersRequest req = this.factory.addLearnersRequest().groupId(this.groupId).learnersList(lrns).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.learners = this.parsePeerList(resp.newLearnersList());
            return null;
        });
    }

    public CompletableFuture<Void> removeLearners(List<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.removeLearners(learners));
        }
        List<String> lrns = learners.stream().map(p -> PeerId.fromPeer(p).toString()).collect(Collectors.toList());
        CliRequests.RemoveLearnersRequest req = this.factory.removeLearnersRequest().groupId(this.groupId).learnersList(lrns).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.learners = this.parsePeerList(resp.newLearnersList());
            return null;
        });
    }

    public CompletableFuture<Void> resetLearners(List<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.resetLearners(learners));
        }
        List<String> lrns = learners.stream().map(p -> PeerId.fromPeer(p).toString()).collect(Collectors.toList());
        CliRequests.ResetLearnersRequest req = this.factory.resetLearnersRequest().groupId(this.groupId).learnersList(lrns).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> {
            this.learners = this.parsePeerList(resp.newLearnersList());
            return null;
        });
    }

    public CompletableFuture<Void> snapshot(Peer peer) {
        CliRequests.SnapshotRequest req = this.factory.snapshotRequest().groupId(this.groupId).build();
        CompletableFuture fut = this.cluster.messagingService().invoke(peer.address(), (NetworkMessage)req, Integer.MAX_VALUE);
        return fut.thenCompose(resp -> {
            RpcRequests.ErrorResponse resp0;
            if (resp != null && (resp0 = (RpcRequests.ErrorResponse)resp).errorCode() != RaftError.SUCCESS.getNumber()) {
                return CompletableFuture.failedFuture((Throwable)((Object)new RaftException(RaftError.forNumber(resp0.errorCode()), resp0.errorMsg())));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> transferLeadership(Peer newLeader) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.transferLeadership(newLeader));
        }
        CliRequests.TransferLeaderRequest req = this.factory.transferLeaderRequest().groupId(this.groupId).leaderId(PeerId.fromPeer(leader).toString()).peerId(PeerId.fromPeer(newLeader).toString()).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenRun(() -> {
            this.leader = newLeader;
        });
    }

    public <R> CompletableFuture<R> run(Command cmd) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader().thenCompose(res -> this.run(cmd));
        }
        ActionRequest req = this.factory.actionRequest().command(cmd).groupId(this.groupId).readOnlySafe(true).build();
        CompletableFuture fut = new CompletableFuture();
        this.sendWithRetry(leader, req, System.currentTimeMillis() + this.timeout, fut);
        return fut.thenApply(resp -> resp.result());
    }

    public <R> CompletableFuture<R> run(Peer peer, ReadCommand cmd) {
        ActionRequest req = this.factory.actionRequest().command((Command)cmd).groupId(this.groupId).readOnlySafe(false).build();
        return this.cluster.messagingService().invoke(peer.address(), (NetworkMessage)req, this.rpcTimeout).thenApply(resp -> ((ActionResponse)resp).result());
    }

    public void shutdown() {
    }

    public ClusterService clusterService() {
        return this.cluster;
    }

    private <R> void sendWithRetry(final Peer peer, final Object req, final long stopTime, final CompletableFuture<R> fut) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("sendWithRetry peers={} req={} from={} to={}", new Object[]{this.peers, S.toString((Object)req), this.cluster.topologyService().localMember().address(), peer.address()});
        }
        if (System.currentTimeMillis() >= stopTime) {
            fut.completeExceptionally(new TimeoutException());
            return;
        }
        CompletableFuture fut0 = this.cluster.messagingService().invoke(peer.address(), (NetworkMessage)req, this.rpcTimeout);
        fut0.whenCompleteAsync(new BiConsumer<Object, Throwable>(){

            @Override
            public void accept(Object resp, Throwable err) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("sendWithRetry resp={} from={} to={} err={}", new Object[]{S.toString((Object)resp), RaftGroupServiceImpl.this.cluster.topologyService().localMember().address(), peer.address(), err == null ? null : err.getMessage()});
                }
                if (err != null) {
                    if (RaftGroupServiceImpl.recoverable(err)) {
                        RaftGroupServiceImpl.this.executor.schedule(() -> {
                            LOG.warn("Recoverable error during the request type={} occurred (will be retried on the randomly selected node): ", err, new Object[]{req.getClass().getSimpleName()});
                            RaftGroupServiceImpl.this.sendWithRetry(RaftGroupServiceImpl.this.randomNode(peer), req, stopTime, fut);
                            return null;
                        }, RaftGroupServiceImpl.this.retryDelay, TimeUnit.MILLISECONDS);
                    } else {
                        fut.completeExceptionally(err);
                    }
                } else if (resp instanceof RpcRequests.ErrorResponse) {
                    RpcRequests.ErrorResponse resp0 = (RpcRequests.ErrorResponse)resp;
                    if (resp0.errorCode() == RaftError.SUCCESS.getNumber()) {
                        RaftGroupServiceImpl.this.leader = peer;
                        fut.complete(null);
                    } else if (resp0.errorCode() == RaftError.EBUSY.getNumber() || resp0.errorCode() == RaftError.EAGAIN.getNumber() || resp0.errorCode() == RaftError.ENOENT.getNumber()) {
                        RaftGroupServiceImpl.this.executor.schedule(() -> {
                            Peer targetPeer = peer;
                            if (resp0.errorCode() == RaftError.ENOENT.getNumber() && (req instanceof CliRequests.GetLeaderRequest || req instanceof CliRequests.ChangePeersAsyncRequest)) {
                                targetPeer = RaftGroupServiceImpl.this.randomNode(peer);
                            }
                            RaftGroupServiceImpl.this.sendWithRetry(targetPeer, req, stopTime, fut);
                            return null;
                        }, RaftGroupServiceImpl.this.retryDelay, TimeUnit.MILLISECONDS);
                    } else if (resp0.errorCode() == RaftError.EPERM.getNumber() || resp0.errorCode() == RaftError.UNKNOWN.getNumber() || resp0.errorCode() == RaftError.EINTERNAL.getNumber()) {
                        if (resp0.leaderId() == null) {
                            RaftGroupServiceImpl.this.executor.schedule(() -> {
                                RaftGroupServiceImpl.this.sendWithRetry(RaftGroupServiceImpl.this.randomNode(peer), req, stopTime, fut);
                                return null;
                            }, RaftGroupServiceImpl.this.retryDelay, TimeUnit.MILLISECONDS);
                        } else {
                            RaftGroupServiceImpl.this.leader = RaftGroupServiceImpl.parsePeer(resp0.leaderId());
                            RaftGroupServiceImpl.this.executor.schedule(() -> {
                                RaftGroupServiceImpl.this.sendWithRetry(RaftGroupServiceImpl.this.leader, req, stopTime, fut);
                                return null;
                            }, RaftGroupServiceImpl.this.retryDelay, TimeUnit.MILLISECONDS);
                        }
                    } else {
                        fut.completeExceptionally((Throwable)((Object)new RaftException(RaftError.forNumber(resp0.errorCode()), resp0.errorMsg())));
                    }
                } else if (resp instanceof RpcRequests.SMErrorResponse) {
                    SMThrowable th = ((RpcRequests.SMErrorResponse)resp).error();
                    if (th instanceof SMCompactedThrowable) {
                        SMCompactedThrowable compactedThrowable = (SMCompactedThrowable)th;
                        try {
                            Throwable restoredTh = (Throwable)Class.forName(compactedThrowable.throwableClassName()).getConstructor(String.class).newInstance(compactedThrowable.throwableMessage());
                            fut.completeExceptionally(restoredTh);
                        }
                        catch (Exception e) {
                            LOG.warn("Cannot restore throwable from user's state machine. Check if throwable " + compactedThrowable.throwableClassName() + " is presented in the classpath.", new Object[0]);
                            fut.completeExceptionally((Throwable)new IgniteException(compactedThrowable.throwableMessage()));
                        }
                    } else if (th instanceof SMFullThrowable) {
                        fut.completeExceptionally(((SMFullThrowable)th).throwable());
                    }
                } else {
                    RaftGroupServiceImpl.this.leader = peer;
                    fut.complete(resp);
                }
            }
        });
    }

    private static boolean recoverable(Throwable t) {
        if (t instanceof ExecutionException || t instanceof CompletionException) {
            t = t.getCause();
        }
        return t instanceof TimeoutException || t instanceof IOException;
    }

    private Peer randomNode() {
        return this.randomNode(null);
    }

    private Peer randomNode(Peer excludedPeer) {
        List<Peer> peers0 = this.peers;
        assert (peers0 != null && !peers0.isEmpty());
        int lastPeerIndex = -1;
        if (excludedPeer != null) {
            lastPeerIndex = peers0.indexOf(excludedPeer);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int newIdx = 0;
        for (int retries = 0; retries < 5 && (newIdx = random.nextInt(peers0.size())) == lastPeerIndex; ++retries) {
        }
        return peers0.get(newIdx);
    }

    private static Peer parsePeer(String peerId) {
        return RaftGroupServiceImpl.peerFromPeerId(PeerId.parsePeer(peerId));
    }

    private static Peer peerFromPeerId(PeerId peer) {
        if (peer == null) {
            return null;
        }
        return new Peer(NetworkAddress.from((String)(peer.getEndpoint().getIp() + ":" + peer.getEndpoint().getPort())));
    }

    private List<Peer> parsePeerList(Collection<String> peers) {
        if (peers == null) {
            return null;
        }
        ArrayList<Peer> res = new ArrayList<Peer>(peers.size());
        for (String peer : peers) {
            res.add(RaftGroupServiceImpl.parsePeer(peer));
        }
        return res;
    }
}

