/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapAggregateBase;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteSortAggregateBase;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class IgniteMapSortAggregate
extends IgniteMapAggregateBase
implements IgniteSortAggregateBase {
    private final RelCollation collation;

    public IgniteMapSortAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, RelCollation collation) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        assert (Objects.nonNull(collation));
        assert (!collation.isDefault());
        this.collation = collation;
    }

    public IgniteMapSortAggregate(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        this.collation = input.getCollation();
        assert (Objects.nonNull(this.collation));
        assert (!this.collation.isDefault());
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new IgniteMapSortAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls, TraitUtils.collation(traitSet));
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteMapSortAggregate(cluster, this.getTraitSet().replace((RelTrait)this.collation), (RelNode)IgniteMapSortAggregate.sole(inputs), this.getGroupSet(), (List<ImmutableBitSet>)this.getGroupSets(), this.getAggCallList(), this.collation);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("collation", (Object)this.collation);
    }

    protected RelDataType deriveRowType() {
        IgniteTypeFactory typeFactory = Commons.typeFactory(this.getCluster());
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        this.groupSet.forEach(fieldIdx -> {
            RelDataTypeField fld = (RelDataTypeField)this.input.getRowType().getFieldList().get((int)fieldIdx);
            builder.add(fld);
        });
        if (!this.aggCalls.isEmpty()) {
            builder.add("AGG_DATA", typeFactory.createArrayType(typeFactory.createJavaType(Accumulator.class), -1L));
        }
        return builder.build();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSelfCostSort(planner, mq);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }
}

