/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class ConcurrentStripedPool<E>
implements Iterable<E> {
    private final ConcurrentLinkedQueue<E>[] stripePools;
    private final int stripes;
    private AtomicInteger[] stripeSize;
    private int maxPoolSize;

    public ConcurrentStripedPool(int stripes, int maxPoolSize) {
        this.stripes = stripes;
        this.maxPoolSize = maxPoolSize;
        this.stripePools = new ConcurrentLinkedQueue[stripes];
        this.stripeSize = new AtomicInteger[stripes];
        for (int i = 0; i < stripes; ++i) {
            this.stripePools[i] = new ConcurrentLinkedQueue();
            this.stripeSize[i] = new AtomicInteger();
        }
    }

    public boolean recycle(E e) {
        int idx = (int)(Thread.currentThread().getId() % (long)this.stripes);
        if (this.stripeSize[idx].get() > this.maxPoolSize) {
            return false;
        }
        this.stripePools[idx].add(e);
        this.stripeSize[idx].incrementAndGet();
        return true;
    }

    public E borrow() {
        int idx = (int)(Thread.currentThread().getId() % (long)this.stripes);
        E r = this.stripePools[idx].poll();
        if (r != null) {
            this.stripeSize[idx].decrementAndGet();
        }
        return r;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.stripes; ++i) {
            this.stripePools[i].forEach(action);
        }
    }

    public void clear() {
        for (int i = 0; i < this.stripes; ++i) {
            this.stripePools[i].clear();
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int idx;
            private Iterator<E> it;
            {
                this.it = ConcurrentStripedPool.this.stripePools[this.idx].iterator();
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (++this.idx >= ConcurrentStripedPool.this.stripes) break;
                    this.it = ConcurrentStripedPool.this.stripePools[this.idx].iterator();
                }
                return false;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.it.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public void resize(int size) {
        this.maxPoolSize = size;
    }
}

