/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheAttributesObsoleteEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheVersion obsoleteVer;

    GridCacheAttributesObsoleteEntryExtras(GridCacheVersion obsoleteVer) {
        assert (obsoleteVer != null);
        this.obsoleteVer = obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        return mvcc != null ? new GridCacheAttributesMvccObsoleteEntryExtras(mvcc, this.obsoleteVer) : this;
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        return this.obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        if (obsoleteVer != null) {
            this.obsoleteVer = obsoleteVer;
            return this;
        }
        return new GridCacheAttributesEntryExtras();
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        return expireTime != 0L ? new GridCacheAttributesObsoleteTtlEntryExtras(this.obsoleteVer, ttl, expireTime) : this;
    }

    @Override
    public int size() {
        return 8;
    }

    public String toString() {
        return S.toString(GridCacheAttributesObsoleteEntryExtras.class, this);
    }
}

