/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Map;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgnitePredicate;

public class CacheGroupView {
    private final CacheGroupDescriptor grp;
    private final CacheConfiguration<?, ?> ccfg;

    public CacheGroupView(CacheGroupDescriptor grp) {
        this.grp = grp;
        this.ccfg = grp.config();
    }

    public int cacheGroupId() {
        return this.grp.groupId();
    }

    @Order
    public String cacheGroupName() {
        return this.grp.cacheOrGroupName();
    }

    public boolean isShared() {
        return this.grp.sharedGroup();
    }

    @Order(value=1)
    public int cacheCount() {
        Map<String, Integer> caches = this.grp.caches();
        return caches == null ? 0 : caches.size();
    }

    @Order(value=3)
    public CacheMode cacheMode() {
        return this.ccfg.getCacheMode();
    }

    @Order(value=4)
    public CacheAtomicityMode atomicityMode() {
        return this.ccfg.getAtomicityMode();
    }

    public String affinity() {
        return this.ccfg.getAffinity() != null ? IgniteUtils.toStringSafe(this.ccfg.getAffinity()) : null;
    }

    public int partitionsCount() {
        return this.ccfg.getAffinity() != null ? this.ccfg.getAffinity().partitions() : -1;
    }

    public String nodeFilter() {
        return CacheGroupView.nodeFilter(this.ccfg);
    }

    public static String nodeFilter(CacheConfiguration<?, ?> ccfg) {
        IgnitePredicate<ClusterNode> nodeFilter = ccfg.getNodeFilter();
        if (nodeFilter instanceof CacheConfiguration.IgniteAllNodesPredicate) {
            return null;
        }
        return IgniteUtils.toStringSafe(nodeFilter);
    }

    @Order(value=2)
    public String dataRegionName() {
        return this.ccfg.getDataRegionName();
    }

    public String topologyValidator() {
        TopologyValidator validator = this.ccfg.getTopologyValidator();
        return validator == null ? null : IgniteUtils.toStringSafe(validator);
    }

    public PartitionLossPolicy partitionLossPolicy() {
        return this.ccfg.getPartitionLossPolicy();
    }

    public CacheRebalanceMode rebalanceMode() {
        return this.ccfg.getRebalanceMode();
    }

    public long rebalanceDelay() {
        return this.ccfg.getRebalanceDelay();
    }

    public int rebalanceOrder() {
        return this.ccfg.getRebalanceOrder();
    }

    public int backups() {
        return this.ccfg.getBackups();
    }
}

