/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistoryItem;

public class BaselineTopologyHistory
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String METASTORE_BLT_HIST_PREFIX = "bltHist-";
    private final Queue<BaselineTopologyHistoryItem> bufferedForStore = new ConcurrentLinkedQueue<BaselineTopologyHistoryItem>();
    private final List<BaselineTopologyHistoryItem> hist = new ArrayList<BaselineTopologyHistoryItem>();

    void restoreHistory(ReadOnlyMetastorage metastorage, int lastId) throws IgniteCheckedException {
        for (int i = 0; i < lastId; ++i) {
            BaselineTopologyHistoryItem histItem = (BaselineTopologyHistoryItem)metastorage.read(METASTORE_BLT_HIST_PREFIX + i);
            if (histItem == null) {
                throw new IgniteCheckedException("Restoring of BaselineTopology history has failed, expected history item not found for id=" + i);
            }
            this.hist.add(histItem);
        }
    }

    BaselineTopologyHistory tailFrom(int id) {
        BaselineTopologyHistory tail = new BaselineTopologyHistory();
        for (BaselineTopologyHistoryItem item : this.hist) {
            if (item.id() < id) continue;
            tail.hist.add(item);
        }
        return tail;
    }

    void writeHistoryItem(ReadWriteMetastorage metastorage, BaselineTopologyHistoryItem histItem) throws IgniteCheckedException {
        if (histItem == null) {
            return;
        }
        this.hist.add(histItem);
        metastorage.write(METASTORE_BLT_HIST_PREFIX + histItem.id(), histItem);
    }

    void removeHistory(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        if (this.hist.isEmpty()) {
            return;
        }
        for (BaselineTopologyHistoryItem histItem : this.hist) {
            metastorage.remove(METASTORE_BLT_HIST_PREFIX + histItem.id());
        }
        this.hist.clear();
    }

    boolean isCompatibleWith(BaselineTopology blt) {
        BaselineTopologyHistoryItem histBlt = this.hist.get(blt.id());
        return histBlt.branchingHistory().contains(blt.branchingPointHash());
    }

    boolean isEmpty() {
        return this.hist.isEmpty();
    }

    void bufferHistoryItemForStore(BaselineTopologyHistoryItem histItem) {
        this.hist.add(histItem);
        this.bufferedForStore.add(histItem);
    }

    public List<BaselineTopologyHistoryItem> history() {
        return Collections.unmodifiableList(this.hist);
    }

    void flushHistoryItems(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        while (!this.bufferedForStore.isEmpty()) {
            BaselineTopologyHistoryItem item = this.bufferedForStore.remove();
            metastorage.write(METASTORE_BLT_HIST_PREFIX + item.id(), item);
        }
    }
}

