/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopFileException;

public class DbCacheEntry {
    private String dbname;
    private String sql;
    private int hashCode;

    public DbCacheEntry(String dbname, String sql) {
        this.dbname = dbname;
        this.sql = sql;
    }

    public DbCacheEntry() {
        this(null, null);
    }

    public boolean sameDB(String otherDb) {
        if (this.dbname == otherDb) {
            return true;
        }
        if (null != this.dbname) {
            return this.dbname.equalsIgnoreCase(otherDb);
        }
        return false;
    }

    public int hashCode() {
        if (0 >= this.hashCode && null != this.dbname && null != this.sql) {
            this.hashCode = this.dbname.toLowerCase().hashCode() ^ this.sql.toLowerCase().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DbCacheEntry) {
            DbCacheEntry dbCacheEntry = (DbCacheEntry)o;
            return this.dbname.equalsIgnoreCase(dbCacheEntry.dbname) && this.sql.equalsIgnoreCase(dbCacheEntry.sql);
        }
        return false;
    }

    public DbCacheEntry(DataInputStream dis) throws HopFileException {
        try {
            this.dbname = dis.readUTF();
            this.sql = dis.readUTF();
        }
        catch (EOFException eof) {
            throw new HopEofException("End of file reached", eof);
        }
        catch (Exception e) {
            throw new HopFileException("Unable to read cache entry from data input stream", e);
        }
    }

    public boolean write(DataOutputStream dos) {
        try {
            dos.writeUTF(this.dbname);
            dos.writeUTF(this.sql);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

