/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.DataTypeUtils;
import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.InetAddressConverter;
import com.clickhouse.client.api.data_formats.internal.NumberConverter;
import com.clickhouse.client.api.internal.MapUtils;
import com.clickhouse.client.api.metadata.NoSuchColumnException;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.NullValueException;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.client.api.serde.POJOFieldDeserializer;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.value.ClickHouseBitmap;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBinaryFormatReader
implements ClickHouseBinaryFormatReader {
    public static final Map<ClickHouseDataType, Class<?>> NO_TYPE_HINT_MAPPING = Collections.emptyMap();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBinaryFormatReader.class);
    protected InputStream input;
    protected BinaryStreamReader binaryStreamReader;
    private TableSchema schema;
    private ClickHouseColumn[] columns;
    private Map[] convertions;
    private boolean hasNext = true;
    private boolean initialState = true;
    protected Object[] currentRecord;
    protected Object[] nextRecord;
    protected boolean nextRecordEmpty = true;

    protected AbstractBinaryFormatReader(InputStream inputStream, QuerySettings querySettings, TableSchema schema, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator, Map<ClickHouseDataType, Class<?>> defaultTypeHintMap) {
        TimeZone timeZone;
        this.input = inputStream;
        Map<Object, Object> settings = querySettings == null ? Collections.emptyMap() : querySettings.getAllSettings();
        Boolean useServerTimeZone = (Boolean)settings.get(ClientConfigProperties.USE_SERVER_TIMEZONE.getKey());
        TimeZone timeZone2 = timeZone = useServerTimeZone == Boolean.TRUE && querySettings != null ? querySettings.getServerTimeZone() : (TimeZone)settings.get(ClientConfigProperties.USE_TIMEZONE.getKey());
        if (timeZone == null) {
            throw new ClientException("Time zone is not set. (useServerTimezone:" + useServerTimeZone + ")");
        }
        boolean jsonAsString = MapUtils.getFlag(settings, ClientConfigProperties.serverSetting("output_format_binary_write_json_as_string"), false);
        this.binaryStreamReader = new BinaryStreamReader(inputStream, timeZone, LOG, byteBufferAllocator, jsonAsString, defaultTypeHintMap);
        if (schema != null) {
            this.setSchema(schema);
        }
    }

    public boolean readToPOJO(Map<String, POJOFieldDeserializer> deserializers, Object obj) throws IOException {
        if (this.columns == null || this.columns.length == 0) {
            return false;
        }
        boolean firstColumn = true;
        for (ClickHouseColumn column : this.columns) {
            try {
                POJOFieldDeserializer deserializer = deserializers.get(column.getColumnName());
                if (deserializer != null) {
                    deserializer.setValue(obj, this.binaryStreamReader, column);
                } else {
                    this.binaryStreamReader.skipValue(column);
                }
                firstColumn = false;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("Failed to set value of '" + column.getColumnName(), e);
            }
        }
        return true;
    }

    public boolean readRecord(Map<String, Object> record) throws IOException {
        if (this.columns == null || this.columns.length == 0) {
            return false;
        }
        boolean firstColumn = true;
        for (ClickHouseColumn column : this.columns) {
            try {
                Object val = this.binaryStreamReader.readValue(column);
                if (val != null) {
                    record.put(column.getColumnName(), val);
                } else {
                    record.remove(column.getColumnName());
                }
                firstColumn = false;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    protected boolean readRecord(Object[] record) throws IOException {
        if (this.columns == null || this.columns.length == 0) {
            return false;
        }
        boolean firstColumn = true;
        for (int i = 0; i < this.columns.length; ++i) {
            try {
                Object val = this.binaryStreamReader.readValue(this.columns[i]);
                record[i] = val != null ? val : null;
                firstColumn = false;
                continue;
            }
            catch (EOFException e) {
                if (firstColumn) {
                    this.endReached();
                    return false;
                }
                throw e;
            }
        }
        return true;
    }

    @Override
    public <T> T readValue(int colIndex) {
        if (colIndex < 1 || colIndex > this.getSchema().getColumns().size()) {
            throw new ClientException("Column index out of bounds: " + colIndex);
        }
        return (T)this.currentRecord[colIndex - 1];
    }

    @Override
    public <T> T readValue(String colName) {
        return (T)this.currentRecord[this.getSchema().nameToIndex(colName)];
    }

    @Override
    public boolean hasNext() {
        if (this.initialState) {
            this.readNextRecord();
        }
        return this.hasNext;
    }

    protected void readNextRecord() {
        this.initialState = false;
        try {
            this.nextRecordEmpty = true;
            if (!this.readRecord(this.nextRecord)) {
                this.endReached();
            } else {
                this.nextRecordEmpty = false;
            }
        }
        catch (IOException e) {
            this.endReached();
            throw new ClientException("Failed to read next row", e);
        }
    }

    @Override
    public Map<String, Object> next() {
        if (!this.hasNext) {
            return null;
        }
        if (!this.nextRecordEmpty) {
            Object[] tmp = this.currentRecord;
            this.currentRecord = this.nextRecord;
            this.nextRecord = tmp;
            this.readNextRecord();
            return new RecordWrapper(this.currentRecord, this.schema);
        }
        try {
            if (this.readRecord(this.currentRecord)) {
                this.readNextRecord();
                return new RecordWrapper(this.currentRecord, this.schema);
            }
            this.currentRecord = null;
            return null;
        }
        catch (IOException e) {
            this.endReached();
            throw new ClientException("Failed to read row", e);
        }
    }

    protected void endReached() {
        this.initialState = false;
        this.hasNext = false;
    }

    protected void setSchema(TableSchema schema) {
        this.schema = schema;
        this.columns = schema.getColumns().toArray(ClickHouseColumn.EMPTY_ARRAY);
        this.convertions = new Map[this.columns.length];
        this.currentRecord = new Object[this.columns.length];
        this.nextRecord = new Object[this.columns.length];
        block3: for (int i = 0; i < this.columns.length; ++i) {
            ClickHouseColumn column = this.columns[i];
            ClickHouseDataType columnDataType = column.getDataType();
            if (columnDataType.equals(ClickHouseDataType.SimpleAggregateFunction)) {
                columnDataType = column.getNestedColumns().get(0).getDataType();
            }
            switch (columnDataType) {
                case Int8: 
                case Int16: 
                case UInt8: 
                case Int32: 
                case UInt16: 
                case Int64: 
                case UInt32: 
                case Int128: 
                case UInt64: 
                case Int256: 
                case UInt128: 
                case UInt256: 
                case Float32: 
                case Float64: 
                case Decimal: 
                case Decimal32: 
                case Decimal64: 
                case Decimal128: 
                case Decimal256: 
                case Bool: 
                case String: 
                case Enum8: 
                case Enum16: 
                case Variant: 
                case Dynamic: 
                case Time: 
                case Time64: {
                    this.convertions[i] = NumberConverter.NUMBER_CONVERTERS;
                    continue block3;
                }
                default: {
                    this.convertions[i] = Collections.emptyMap();
                }
            }
        }
    }

    public Map[] getConvertions() {
        return this.convertions;
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getString(String colName) {
        return AbstractBinaryFormatReader.readAsString(this.readValue(colName), this.schema.getColumnByName(colName));
    }

    public static String readAsString(Object value, ClickHouseColumn column) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ZonedDateTime) {
            ClickHouseDataType dataType = column.getDataType();
            ZonedDateTime zdt = (ZonedDateTime)value;
            switch (dataType) {
                case Date: 
                case Date32: {
                    return zdt.format(DataTypeUtils.DATE_FORMATTER);
                }
                case DateTime: 
                case DateTime32: {
                    return zdt.format(DataTypeUtils.DATETIME_FORMATTER);
                }
                case DateTime64: {
                    return zdt.format(DataTypeUtils.DATETIME_WITH_NANOS_FORMATTER);
                }
            }
            return value.toString();
        }
        if (value instanceof BinaryStreamReader.EnumValue) {
            return ((BinaryStreamReader.EnumValue)value).name;
        }
        if (value instanceof Number) {
            ClickHouseDataType dataType = column.getDataType();
            int num = ((Number)value).intValue();
            if (column.getDataType() == ClickHouseDataType.Variant) {
                for (ClickHouseColumn c : column.getNestedColumns()) {
                    if (c.getDataType() != ClickHouseDataType.Enum8 && c.getDataType() != ClickHouseDataType.Enum16) continue;
                    return c.getEnumConstants().name(num);
                }
            } else if (dataType == ClickHouseDataType.Enum8 || dataType == ClickHouseDataType.Enum16) {
                return column.getEnumConstants().name(num);
            }
        } else if (value instanceof BinaryStreamReader.ArrayValue) {
            return ((BinaryStreamReader.ArrayValue)value).asList().toString();
        }
        return value.toString();
    }

    @Override
    public String getString(int index) {
        return this.getString(this.schema.columnIndexToName(index));
    }

    private <T> T readNumberValue(String colName, NumberConverter.NumberType targetType) {
        int colIndex = this.schema.nameToIndex(colName);
        Function converter = (Function)this.convertions[colIndex].get((Object)targetType);
        if (converter != null) {
            T value = this.readValue(colName);
            if (value == null) {
                throw new NullValueException("Column " + colName + " has null value and it cannot be cast to " + targetType.getTypeName());
            }
            return (T)converter.apply(value);
        }
        throw new ClientException("Column " + colName + " " + this.columns[colIndex].getDataType().name() + " cannot be converted to " + targetType.getTypeName());
    }

    @Override
    public byte getByte(String colName) {
        return (Byte)this.readNumberValue(colName, NumberConverter.NumberType.Byte);
    }

    @Override
    public short getShort(String colName) {
        return (Short)this.readNumberValue(colName, NumberConverter.NumberType.Short);
    }

    @Override
    public int getInteger(String colName) {
        return (Integer)this.readNumberValue(colName, NumberConverter.NumberType.Int);
    }

    @Override
    public long getLong(String colName) {
        return (Long)this.readNumberValue(colName, NumberConverter.NumberType.Long);
    }

    @Override
    public float getFloat(String colName) {
        return ((Float)this.readNumberValue(colName, NumberConverter.NumberType.Float)).floatValue();
    }

    @Override
    public double getDouble(String colName) {
        return (Double)this.readNumberValue(colName, NumberConverter.NumberType.Double);
    }

    @Override
    public boolean getBoolean(String colName) {
        return (Boolean)this.readNumberValue(colName, NumberConverter.NumberType.Boolean);
    }

    @Override
    public BigInteger getBigInteger(String colName) {
        return (BigInteger)this.readNumberValue(colName, NumberConverter.NumberType.BigInteger);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        return (BigDecimal)this.readNumberValue(colName, NumberConverter.NumberType.BigDecimal);
    }

    @Override
    public Instant getInstant(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        ClickHouseDataType columnDataType = column.getDataType();
        if (columnDataType.equals(ClickHouseDataType.SimpleAggregateFunction)) {
            columnDataType = column.getNestedColumns().get(0).getDataType();
        }
        switch (columnDataType) {
            case Date: 
            case Date32: {
                LocalDate data = (LocalDate)this.readValue(colName);
                return data.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            case DateTime: 
            case DateTime64: {
                Object colValue = this.readValue(colName);
                if (colValue instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)colValue;
                    return dateTime.toInstant(column.getTimeZone().toZoneId().getRules().getOffset(dateTime));
                }
                ZonedDateTime dateTime = (ZonedDateTime)colValue;
                return dateTime.toInstant();
            }
            case Time: {
                return Instant.ofEpochSecond(this.getLong(colName));
            }
            case Time64: {
                return DataTypeUtils.instantFromTime64Integer(column.getScale(), this.getLong(colName));
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Instant");
    }

    @Override
    public ZonedDateTime getZonedDateTime(String colName) {
        int colIndex = this.schema.nameToIndex(colName);
        ClickHouseColumn column = this.schema.getColumns().get(colIndex);
        ClickHouseDataType columnDataType = column.getDataType();
        if (columnDataType.equals(ClickHouseDataType.SimpleAggregateFunction)) {
            columnDataType = column.getNestedColumns().get(0).getDataType();
        }
        switch (columnDataType) {
            case Date: 
            case Date32: 
            case DateTime: 
            case DateTime64: {
                return (ZonedDateTime)this.readValue(colName);
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to ZonedDateTime");
    }

    @Override
    public Duration getDuration(String colName) {
        TemporalAmount temporalAmount = this.getTemporalAmount(colName);
        return Duration.from(temporalAmount);
    }

    @Override
    public TemporalAmount getTemporalAmount(String colName) {
        return (TemporalAmount)this.readValue(colName);
    }

    @Override
    public Inet4Address getInet4Address(String colName) {
        return InetAddressConverter.convertToIpv4((InetAddress)this.readValue(colName));
    }

    @Override
    public Inet6Address getInet6Address(String colName) {
        return InetAddressConverter.convertToIpv6((InetAddress)this.readValue(colName));
    }

    @Override
    public UUID getUUID(String colName) {
        return (UUID)this.readValue(colName);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(String colName) {
        return ClickHouseGeoPointValue.of((double[])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(String colName) {
        return ClickHouseGeoRingValue.of((double[][])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(String colName) {
        return ClickHouseGeoPolygonValue.of((double[][][])this.readValue(colName));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(String colName) {
        return ClickHouseGeoMultiPolygonValue.of((double[][][][])this.readValue(colName));
    }

    @Override
    public <T> List<T> getList(String colName) {
        T value = this.readValue(colName);
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return ((BinaryStreamReader.ArrayValue)value).asList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new ClientException("Column is not of array type");
    }

    private <T> T getPrimitiveArray(String colName, Class<?> componentType) {
        try {
            T value = this.readValue(colName);
            if (value instanceof BinaryStreamReader.ArrayValue) {
                BinaryStreamReader.ArrayValue array = (BinaryStreamReader.ArrayValue)value;
                if (array.itemType.isPrimitive()) {
                    return (T)array.array;
                }
                throw new ClientException("Array is not of primitive type");
            }
            if (value instanceof List) {
                List list = (List)value;
                Object array = Array.newInstance(componentType, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(array, i, list.get(i));
                }
                return (T)array;
            }
            throw new ClientException("Column is not of array type");
        }
        catch (ClassCastException e) {
            throw new ClientException("Column is not of array type", e);
        }
    }

    @Override
    public byte[] getByteArray(String colName) {
        try {
            return (byte[])this.getPrimitiveArray(colName, Byte.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public int[] getIntArray(String colName) {
        try {
            return (int[])this.getPrimitiveArray(colName, Integer.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public long[] getLongArray(String colName) {
        try {
            return (long[])this.getPrimitiveArray(colName, Long.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public float[] getFloatArray(String colName) {
        try {
            return (float[])this.getPrimitiveArray(colName, Float.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public double[] getDoubleArray(String colName) {
        try {
            return (double[])this.getPrimitiveArray(colName, Double.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public boolean[] getBooleanArray(String colName) {
        try {
            return (boolean[])this.getPrimitiveArray(colName, Boolean.TYPE);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ClientException("Value cannot be converted to an array of primitives", e);
        }
    }

    @Override
    public boolean hasValue(int colIndex) {
        return this.currentRecord[colIndex - 1] != null;
    }

    @Override
    public boolean hasValue(String colName) {
        return this.currentRecord[this.getSchema().nameToIndex(colName)] != null;
    }

    @Override
    public byte getByte(int index) {
        return this.getByte(this.schema.columnIndexToName(index));
    }

    @Override
    public short getShort(int index) {
        return this.getShort(this.schema.columnIndexToName(index));
    }

    @Override
    public int getInteger(int index) {
        return this.getInteger(this.schema.columnIndexToName(index));
    }

    @Override
    public long getLong(int index) {
        return this.getLong(this.schema.columnIndexToName(index));
    }

    @Override
    public float getFloat(int index) {
        return this.getFloat(this.schema.columnIndexToName(index));
    }

    @Override
    public double getDouble(int index) {
        return this.getDouble(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getBoolean(this.schema.columnIndexToName(index));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        return this.getBigInteger(this.schema.columnIndexToName(index));
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.getBigDecimal(this.schema.columnIndexToName(index));
    }

    @Override
    public Instant getInstant(int index) {
        return this.getInstant(this.schema.columnIndexToName(index));
    }

    @Override
    public ZonedDateTime getZonedDateTime(int index) {
        return (ZonedDateTime)this.readValue(index);
    }

    @Override
    public Duration getDuration(int index) {
        return this.getDuration(this.schema.columnIndexToName(index));
    }

    @Override
    public TemporalAmount getTemporalAmount(int index) {
        return this.getTemporalAmount(this.schema.columnIndexToName(index));
    }

    @Override
    public Inet4Address getInet4Address(int index) {
        return InetAddressConverter.convertToIpv4((InetAddress)this.readValue(index));
    }

    @Override
    public Inet6Address getInet6Address(int index) {
        return InetAddressConverter.convertToIpv6((InetAddress)this.readValue(index));
    }

    @Override
    public UUID getUUID(int index) {
        return (UUID)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(int index) {
        return this.getGeoPoint(this.schema.columnIndexToName(index));
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(int index) {
        return this.getGeoRing(this.schema.columnIndexToName(index));
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(int index) {
        return this.getGeoPolygon(this.schema.columnIndexToName(index));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(int index) {
        return this.getGeoMultiPolygon(this.schema.columnIndexToName(index));
    }

    @Override
    public <T> List<T> getList(int index) {
        return this.getList(this.schema.columnIndexToName(index));
    }

    @Override
    public byte[] getByteArray(int index) {
        return this.getByteArray(this.schema.columnIndexToName(index));
    }

    @Override
    public int[] getIntArray(int index) {
        return this.getIntArray(this.schema.columnIndexToName(index));
    }

    @Override
    public long[] getLongArray(int index) {
        return this.getLongArray(this.schema.columnIndexToName(index));
    }

    @Override
    public float[] getFloatArray(int index) {
        return this.getFloatArray(this.schema.columnIndexToName(index));
    }

    @Override
    public double[] getDoubleArray(int index) {
        return this.getDoubleArray(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean[] getBooleanArray(int index) {
        return this.getBooleanArray(this.schema.columnIndexToName(index));
    }

    @Override
    public Object[] getTuple(int index) {
        return (Object[])this.readValue(index);
    }

    @Override
    public Object[] getTuple(String colName) {
        return (Object[])this.readValue(colName);
    }

    @Override
    public byte getEnum8(String colName) {
        BinaryStreamReader.EnumValue enumValue = (BinaryStreamReader.EnumValue)this.readValue(colName);
        return enumValue.byteValue();
    }

    @Override
    public byte getEnum8(int index) {
        return this.getEnum8(this.schema.columnIndexToName(index));
    }

    @Override
    public short getEnum16(String colName) {
        BinaryStreamReader.EnumValue enumValue = (BinaryStreamReader.EnumValue)this.readValue(colName);
        return enumValue.shortValue();
    }

    @Override
    public short getEnum16(int index) {
        return this.getEnum16(this.schema.columnIndexToName(index));
    }

    @Override
    public LocalDate getLocalDate(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate getLocalDate(int index) {
        return this.getLocalDate(this.schema.columnIndexToName(index));
    }

    @Override
    public LocalDateTime getLocalDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return (LocalDateTime)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        return this.getLocalDateTime(this.schema.columnIndexToName(index));
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        return (OffsetDateTime)value;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        return this.getOffsetDateTime(this.schema.columnIndexToName(index));
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(String colName) {
        return (ClickHouseBitmap)this.readValue(colName);
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(int index) {
        return (ClickHouseBitmap)this.readValue(index);
    }

    @Override
    public void close() throws Exception {
        this.input.close();
    }

    private static class RecordWrapper
    implements Map<String, Object> {
        private final WeakReference<Object[]> recordRef;
        private final WeakReference<TableSchema> schemaRef;
        int size;

        public RecordWrapper(Object[] record, TableSchema schema) {
            this.recordRef = new WeakReference<Object[]>(record);
            this.schemaRef = new WeakReference<TableSchema>(schema);
            this.size = record.length;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                return ((Object[])this.recordRef.get())[((TableSchema)this.schemaRef.get()).nameToIndex((String)key)] != null;
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            for (Object obj : (Object[])this.recordRef.get()) {
                if (obj != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object get(Object key) {
            if (key instanceof String) {
                try {
                    int index = ((TableSchema)this.schemaRef.get()).nameToIndex((String)key);
                    if (index < this.size) {
                        return ((Object[])this.recordRef.get())[index];
                    }
                }
                catch (NoSuchColumnException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Record is read-only");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Record is read-only");
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException("Record is read-only");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Record is read-only");
        }

        @Override
        public Set<String> keySet() {
            return ((TableSchema)this.schemaRef.get()).getColumns().stream().map(ClickHouseColumn::getColumnName).collect(Collectors.toSet());
        }

        @Override
        public Collection<Object> values() {
            return Arrays.asList((Object[])this.recordRef.get());
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            int i = 0;
            HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
            for (ClickHouseColumn column : ((TableSchema)this.schemaRef.get()).getColumns()) {
                entrySet.add(new AbstractMap.SimpleImmutableEntry<String, Object>(column.getColumnName(), ((Object[])this.recordRef.get())[i++]));
            }
            return entrySet;
        }
    }
}

