/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.HTTPProxyException;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.transport.ClientServerHello;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class HTTPProxyData
implements ProxyData {
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPass;
    private final String[] requestHeaderLines;

    public HTTPProxyData(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public HTTPProxyData(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this(proxyHost, proxyPort, proxyUser, proxyPass, null);
    }

    public HTTPProxyData(String proxyHost, int proxyPort, String proxyUser, String proxyPass, String[] requestHeaderLines) {
        if (proxyHost == null) {
            throw new IllegalArgumentException("proxyHost must be non-null");
        }
        if (proxyPort < 0) {
            throw new IllegalArgumentException("proxyPort must be non-negative");
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
        this.requestHeaderLines = requestHeaderLines;
    }

    @Override
    public Socket openConnection(String hostname, int port, int connectTimeout) throws IOException {
        String httpReponse;
        Socket sock = new Socket();
        InetAddress addr = InetAddress.getByName(this.proxyHost);
        sock.connect(new InetSocketAddress(addr, this.proxyPort), connectTimeout);
        sock.setSoTimeout(0);
        StringBuffer sb = new StringBuffer();
        sb.append("CONNECT ");
        sb.append(hostname);
        sb.append(':');
        sb.append(port);
        sb.append(" HTTP/1.0\r\n");
        if (this.proxyUser != null && this.proxyPass != null) {
            char[] encoded;
            String credentials = this.proxyUser + ":" + this.proxyPass;
            try {
                encoded = Base64.encode(credentials.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                encoded = Base64.encode(credentials.getBytes());
            }
            sb.append("Proxy-Authorization: Basic ");
            sb.append(encoded);
            sb.append("\r\n");
        }
        if (this.requestHeaderLines != null) {
            for (int i = 0; i < this.requestHeaderLines.length; ++i) {
                if (this.requestHeaderLines[i] == null) continue;
                sb.append(this.requestHeaderLines[i]);
                sb.append("\r\n");
            }
        }
        sb.append("\r\n");
        OutputStream out = sock.getOutputStream();
        try {
            out.write(sb.toString().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            out.write(sb.toString().getBytes());
        }
        out.flush();
        byte[] buffer = new byte[1024];
        InputStream in = sock.getInputStream();
        int len = ClientServerHello.readLineRN(in, buffer);
        try {
            httpReponse = new String(buffer, 0, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            httpReponse = new String(buffer, 0, len);
        }
        if (!httpReponse.startsWith("HTTP/")) {
            throw new IOException("The proxy did not send back a valid HTTP response.");
        }
        if (httpReponse.length() < 14 || httpReponse.charAt(8) != ' ' || httpReponse.charAt(12) != ' ') {
            throw new IOException("The proxy did not send back a valid HTTP response.");
        }
        int errorCode = 0;
        try {
            errorCode = Integer.parseInt(httpReponse.substring(9, 12));
        }
        catch (NumberFormatException ignore) {
            throw new IOException("The proxy did not send back a valid HTTP response.");
        }
        if (errorCode < 0 || errorCode > 999) {
            throw new IOException("The proxy did not send back a valid HTTP response.");
        }
        if (errorCode != 200) {
            throw new HTTPProxyException(httpReponse.substring(13), errorCode);
        }
        while ((len = ClientServerHello.readLineRN(in, buffer)) != 0) {
        }
        return sock;
    }
}

