/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RoutingDataEntry;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SubsystemEntryList {
    private static final QSYSObjectPathName USERSPACE_PATH = new QSYSObjectPathName("QTEMP", "JT4QLSBSE", "USRSPC");
    private static final String SBSE_FORMAT_100 = "SBSE0100";
    private static final String SBSE_FORMAT_200 = "SBSE0200";
    private static final String SBSE_FORMAT_300 = "SBSE0300";
    private static final String SBSE_FORMAT_400 = "SBSE0400";
    private static final String SBSE_FORMAT_500 = "SBSE0500";
    private static final String SBSE_FORMAT_600 = "SBSE0600";
    private static final String SBSE_FORMAT_700 = "SBSE0700";
    public static final int ROUTING_ENTRY = 1;
    public static final int COMMUNICATION_ENTRY = 2;
    public static final int REMOTE_LOCATION_ENTRY = 3;
    public static final int AUTOSTART_JOB_ENTRY = 4;
    public static final int PRESTART_JOB_ENTRY = 5;
    public static final int WORKSTATION_NAME_ENTRY = 6;
    public static final int WORKSTATION_TYPE_ENTRY = 7;
    private AS400 system_;
    private String name_;
    private String library_;
    private int listType_;
    private QSYSObjectPathName path_;
    private final Map routingDataDescription_ = new HashMap();

    public SubsystemEntryList(AS400 system, String library, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("Subsystem library");
        }
        if (name == null) {
            throw new NullPointerException("Subsystem name");
        }
        this.system_ = system;
        this.name_ = name;
        this.library_ = library;
        this.path_ = new QSYSObjectPathName(this.library_, this.name_, "SBSD");
    }

    public SubsystemEntryList(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.path_ = path;
    }

    private String lookupFormat(int listType) {
        String format;
        switch (listType) {
            case 1: {
                format = SBSE_FORMAT_100;
                break;
            }
            case 2: {
                format = SBSE_FORMAT_200;
                break;
            }
            case 3: {
                format = SBSE_FORMAT_300;
                break;
            }
            case 4: {
                format = SBSE_FORMAT_400;
                break;
            }
            case 5: {
                format = SBSE_FORMAT_500;
                break;
            }
            case 6: {
                format = SBSE_FORMAT_600;
                break;
            }
            case 7: {
                format = SBSE_FORMAT_700;
                break;
            }
            default: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unrecognized list type:", listType);
                }
                format = SBSE_FORMAT_100;
            }
        }
        return format;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        ProgramCall program = new ProgramCall(this.system_, "/QSYS.LIB/QWDLSBSE.PGM", this.buildProgramParameters(this.getFormat()));
        boolean willRunProgramsOnThread = program.isStayOnThread();
        Serializable lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.system_;
        Serializable serializable = lockObject;
        synchronized (serializable) {
            UserSpace us = new UserSpace(this.system_, USERSPACE_PATH.getPath());
            us.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                us.setMustUseSockets(true);
            }
            try {
                us.create(65535, true, "JT400", (byte)0, "Userspace for loading members", "*ALL");
                if (!program.run()) {
                    throw new AS400Exception(program.getMessageList());
                }
                byte[] usBuf = new byte[65535];
                int numBytesRead = us.read(usBuf, 0, 0, 144);
                if (numBytesRead < 144) {
                    Trace.log(2, "Failed to read the generic header.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                int offsetToHeaderSection = BinaryConverter.byteArrayToInt(usBuf, 116);
                int headerSectionSize = BinaryConverter.byteArrayToInt(usBuf, 120);
                int offsetToListDataSection = BinaryConverter.byteArrayToInt(usBuf, 124);
                int listDataSectionSize = BinaryConverter.byteArrayToInt(usBuf, 128);
                int numberOfListEntries = BinaryConverter.byteArrayToInt(usBuf, 132);
                int sizeOfEachEntry = BinaryConverter.byteArrayToInt(usBuf, 136);
                int entryCCSID = BinaryConverter.byteArrayToInt(usBuf, 140);
                if (entryCCSID == 0) {
                    entryCCSID = this.system_.getCcsid();
                }
                CharConverter conv = new CharConverter(entryCCSID);
                numBytesRead = us.read(usBuf, offsetToHeaderSection, 0, headerSectionSize);
                if (numBytesRead < headerSectionSize) {
                    Trace.log(2, "Failed to read the header section.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                if (listDataSectionSize > usBuf.length) {
                    usBuf = new byte[listDataSectionSize + 1];
                }
                if ((numBytesRead = us.read(usBuf, offsetToListDataSection, 0, listDataSectionSize)) < listDataSectionSize) {
                    Trace.log(2, "Failed to read the list data section.  Number of bytes read: " + numBytesRead);
                    throw new InternalErrorException(6, numBytesRead);
                }
                String format = this.getFormat();
                for (int i = 0; i < numberOfListEntries; ++i) {
                    byte[] entryBuf = new byte[sizeOfEachEntry];
                    System.arraycopy(usBuf, i * sizeOfEachEntry, entryBuf, 0, sizeOfEachEntry);
                    if (!format.equals(SBSE_FORMAT_100)) continue;
                    this.readRoutingDataEntries(entryBuf, format, conv);
                }
            }
            finally {
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
        }
    }

    private String getFormat() {
        String format = SBSE_FORMAT_100;
        String tempFormat = this.lookupFormat(this.listType_);
        if (format.compareTo(tempFormat) < 0) {
            format = tempFormat;
        }
        return format;
    }

    public void setListType(int type) {
        this.listType_ = type;
    }

    private ProgramParameter[] buildProgramParameters(String format) throws UnsupportedEncodingException {
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(CharConverter.stringToByteArray(this.system_, USERSPACE_PATH.toQualifiedObjectName())), new ProgramParameter(CharConverter.stringToByteArray(this.system_, format)), new ProgramParameter(CharConverter.stringToByteArray(this.system_, this.path_.toQualifiedObjectName())), new ErrorCodeParameter()};
        return parameterList;
    }

    private void readRoutingDataEntries(byte[] entryBuf, String format, CharConverter charConverter) {
        String compareValue = charConverter.byteArrayToString(entryBuf, 56, 10).trim();
        RoutingDataEntry routingDataEntry = (RoutingDataEntry)this.routingDataDescription_.get(compareValue);
        if (routingDataEntry == null) {
            routingDataEntry = new RoutingDataEntry();
        }
        int offset = 0;
        int routingEntrySequenceNum = BinaryConverter.byteArrayToInt(entryBuf, offset);
        String routingEntryProgramName = charConverter.byteArrayToString(entryBuf, 4, 10).trim();
        String routingEntryProgramLibrary = charConverter.byteArrayToString(entryBuf, 14, 10).trim();
        String routingEntryClassName = charConverter.byteArrayToString(entryBuf, 24, 10).trim();
        String routingEntryClassLibrary = charConverter.byteArrayToString(entryBuf, 24, 10).trim();
        int maxActiveRoutingSteps = BinaryConverter.byteArrayToInt(entryBuf, 44);
        int routingEntryPoolIden = BinaryConverter.byteArrayToInt(entryBuf, 48);
        int compareStartPosition = BinaryConverter.byteArrayToInt(entryBuf, 52);
        String routingEntryThreadResourcesAffinityGroup = charConverter.byteArrayToString(entryBuf, 136, 10).trim();
        String routingEntryThreadResourcesAffinityLevel = charConverter.byteArrayToString(entryBuf, 146, 10).trim();
        String routingEntryResourcesAffinityGroup = charConverter.byteArrayToString(entryBuf, 156, 10).trim();
        routingDataEntry.setcompareValue(compareValue);
        routingDataEntry.setroutingEntrySequenceNum(routingEntrySequenceNum);
        routingDataEntry.setroutingEntryProgramName(routingEntryProgramName);
        routingDataEntry.setroutingEntryProgramLibrary(routingEntryProgramLibrary);
        routingDataEntry.setroutingEntryClassName(routingEntryClassName);
        routingDataEntry.setroutingEntryClassLibrary(routingEntryClassLibrary);
        routingDataEntry.setmaxActiveRoutingStep(maxActiveRoutingSteps);
        routingDataEntry.setroutingEntryPoolIden(routingEntryPoolIden);
        routingDataEntry.setcompareStartPosition(compareStartPosition);
        routingDataEntry.setroutingEntryThreadResourcesAffinityGroup(routingEntryThreadResourcesAffinityGroup);
        routingDataEntry.setroutingEntryThreadResourcesAffinityLevel(routingEntryThreadResourcesAffinityLevel);
        routingDataEntry.setroutingEntryResourcesAffinityGroup(routingEntryResourcesAffinityGroup);
        this.routingDataDescription_.put(compareValue, routingDataEntry);
    }

    public RoutingDataEntry getRoutingDataEntry(String compareValue) {
        return (RoutingDataEntry)this.routingDataDescription_.get(compareValue);
    }

    public RoutingDataEntry[] getRoutingDataEntry() {
        return this.routingDataDescription_.values().toArray(new RoutingDataEntry[this.routingDataDescription_.size()]);
    }

    public void clear() {
        this.routingDataDescription_.clear();
    }
}

