/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.impala;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="CLOUDERA-IMPALA", typeDescription="Cloudera Impala", image="impala.svg", documentationUrl="/database/databases/cloudera-impala")
@GuiPlugin(id="GUI-ClouderaImpalaDatabaseMeta")
public class ImpalaDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";
    private static final int VARCHAR_LIMIT = 65535;
    @GuiWidgetElement(id="impalaPrincipal", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::ImpalaDatabaseMeta.label.PrincipalName", toolTip="i18n::ImpalaDatabaseMeta.toolTip.PrincipalName")
    @HopMetadataProperty(key="principal")
    private String principalName;

    public String getDriverClass() {
        return "com.cloudera.impala.jdbc.Driver";
    }

    public int getDefaultDatabasePort() {
        return 21050;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public int getMaxTextFieldLength() {
        return 65535;
    }

    public int getMaxVARCHARLength() {
        return 65535;
    }

    public boolean isRequiresName() {
        return false;
    }

    public String getURL(String hostname, String port, String databaseName) {
        String url = "jdbc:impala://" + hostname + ":" + port + "/";
        if (StringUtils.isNotEmpty((String)databaseName)) {
            url = url + databaseName + "/";
        }
        if (StringUtils.isNotEmpty((String)this.principalName)) {
            url = url + ";principal=" + this.principalName;
        }
        return url;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName();
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCR) {
        Object fieldClause = "";
        String fieldName = v.getName();
        if (v.getLength() == 9999999) {
            v.setLength(this.getMaxTextFieldLength());
        }
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            fieldClause = (String)fieldClause + fieldName + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                fieldClause = (String)fieldClause + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    fieldClause = (String)fieldClause + "BOOLEAN";
                    break;
                }
                fieldClause = (String)fieldClause + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldName.equalsIgnoreCase(tk) || fieldName.equalsIgnoreCase(pk)) {
                    fieldClause = (String)fieldClause + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            fieldClause = (String)fieldClause + "BIGINT";
                            break;
                        }
                        fieldClause = (String)fieldClause + "DECIMAL(" + length + ")";
                        break;
                    }
                    fieldClause = (String)fieldClause + "INT";
                    break;
                }
                if (length > 15) {
                    fieldClause = (String)fieldClause + "DECIMAL(" + length;
                    if (precision > 0) {
                        fieldClause = (String)fieldClause + ", " + precision;
                    }
                    fieldClause = (String)fieldClause + ")";
                    break;
                }
                fieldClause = (String)fieldClause + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length == 1) {
                        fieldClause = (String)fieldClause + "CHAR(1)";
                        break;
                    }
                    if (length < 65536) {
                        fieldClause = (String)fieldClause + "VARCHAR(" + length + ")";
                        break;
                    }
                    fieldClause = (String)fieldClause + "VARCHAR(65535)";
                    break;
                }
                fieldClause = (String)fieldClause + "VARCHAR(65535)";
                break;
            }
            case 8: {
                fieldClause = (String)fieldClause + "!! BINARY DATA TYPE ARE NOT SUPPORTED ON IMPALA !!";
                break;
            }
            default: {
                fieldClause = (String)fieldClause + " !! UNKNOWN DATA TYPE FOR IMPALA !!";
            }
        }
        if (addCR) {
            fieldClause = (String)fieldClause + Const.CR;
        }
        return fieldClause;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }
}

