/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringcut;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringcut.StringCut;
import org.apache.hop.pipeline.transforms.stringcut.StringCutData;
import org.apache.hop.pipeline.transforms.stringcut.StringCutField;

@Transform(id="StringCut", image="stringcut.svg", name="i18n::StringCut.Name", description="i18n::StringCut.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::StringCutMeta.keyword"}, documentationUrl="/pipeline/transforms/stringcut.html")
public class StringCutMeta
extends BaseTransformMeta<StringCut, StringCutData> {
    private static final Class<?> PKG = StringCutMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="StringCutMeta.Injection.Fields", injectionKeyDescription="StringCutMeta.Injection.Field")
    private List<StringCutField> fields = new ArrayList<StringCutField>();

    public StringCutMeta() {
    }

    public StringCutMeta(StringCutMeta obj) {
        for (StringCutField field : obj.fields) {
            this.fields.add(new StringCutField(field));
        }
    }

    public Object clone() {
        return new StringCutMeta(this);
    }

    public List<StringCutField> getFields() {
        return this.fields;
    }

    public void setFields(List<StringCutField> fields) {
        this.fields = fields;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fields.size(); ++i) {
            IValueMeta v;
            String fieldOutStream = this.fields.get(i).getFieldOutStream();
            String fieldInStream = this.fields.get(i).getFieldInStream();
            if (!Utils.isEmpty((CharSequence)fieldOutStream)) {
                v = new ValueMetaString(variables.resolve(fieldOutStream));
                v.setLength(100, -1);
                v.setOrigin(name);
                inputRowMeta.addValueMeta(v);
                continue;
            }
            v = inputRowMeta.searchValueMeta(fieldInStream);
            if (v == null) continue;
            v.setStorageType(0);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        Object errorMessage = "";
        boolean first = true;
        boolean errorFound = false;
        if (prev == null) {
            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.NoInputReceived", (String[])new String[0]) + Const.CR;
            CheckResult cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            IValueMeta v;
            String field;
            for (StringCutField scf : this.fields) {
                field = scf.getFieldInStream();
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.MissingInStreamFields", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
            }
            CheckResult cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            first = true;
            errorFound = false;
            for (StringCutField scf : this.fields) {
                field = scf.getFieldInStream();
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
            }
            cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            if (!this.fields.isEmpty()) {
                int idx = 0;
                for (StringCutField scf : this.fields) {
                    if (Utils.isEmpty((CharSequence)scf.getFieldInStream())) {
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{Integer.toString(idx + 1)}), (ICheckResultSource)transforminfo);
                        remarks.add((ICheckResult)cr);
                    }
                    ++idx;
                }
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

