/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosRequestCallback;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.ConditionAsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosPropose<OnDone extends Consumer<? super Status>>
extends PaxosRequestCallback<Response> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosPropose.class);
    public static final RequestHandler requestHandler = new RequestHandler();
    public static final RequestSerializer requestSerializer = new RequestSerializer();
    public static final ResponseSerializer responseSerializer = new ResponseSerializer();
    private static final Status success = new Status(Status.Outcome.SUCCESS);
    private static final AtomicLongFieldUpdater<PaxosPropose> responsesUpdater = AtomicLongFieldUpdater.newUpdater(PaxosPropose.class, "responses");
    private static final AtomicReferenceFieldUpdater<PaxosPropose, Ballot> supersededByUpdater = AtomicReferenceFieldUpdater.newUpdater(PaxosPropose.class, Ballot.class, "supersededBy");
    @VisibleForTesting
    public static final long ACCEPT_INCREMENT = 1L;
    private static final int REFUSAL_SHIFT = 21;
    @VisibleForTesting
    public static final long REFUSAL_INCREMENT = 0x200000L;
    private static final int FAILURE_SHIFT = 42;
    @VisibleForTesting
    public static final long FAILURE_INCREMENT = 0x40000000000L;
    private static final long MASK = 0x1FFFFFL;
    private final Commit.Proposal proposal;
    private final boolean waitForNoSideEffect;
    final int participants;
    final int required;
    final OnDone onDone;
    private volatile long responses;
    private volatile Ballot supersededBy;

    private PaxosPropose(Commit.Proposal proposal, int participants, int required, boolean waitForNoSideEffect, OnDone onDone) {
        this.proposal = proposal;
        assert (required > 0);
        this.waitForNoSideEffect = waitForNoSideEffect;
        this.participants = participants;
        this.required = required;
        this.onDone = onDone;
    }

    static Paxos.Async<Status> propose(Commit.Proposal proposal, Paxos.Participants participants, boolean waitForNoSideEffect) {
        if (waitForNoSideEffect && proposal.update.isEmpty()) {
            waitForNoSideEffect = false;
        }
        class Async
        extends PaxosPropose<ConditionAsConsumer<Status>>
        implements Paxos.Async<Status> {
            Async(Commit.Proposal proposal, int participants, int required, boolean waitForNoSideEffect) {
                super(proposal, participants, required, waitForNoSideEffect, ConditionAsConsumer.newConditionAsConsumer(), null);
            }

            @Override
            public Status awaitUntil(long deadline) {
                try {
                    ((ConditionAsConsumer)this.onDone).awaitUntil(deadline);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return new MaybeFailure(new Paxos.MaybeFailure(true, this.participants, this.required, 0, Collections.emptyMap()));
                }
                return this.status();
            }
        }
        Async propose = new Async(proposal, participants.sizeOfPoll(), participants.sizeOfConsensusQuorum, waitForNoSideEffect);
        propose.start(participants);
        return propose;
    }

    static <T extends Consumer<Status>> T propose(Commit.Proposal proposal, Paxos.Participants participants, boolean waitForNoSideEffect, T onDone) {
        if (waitForNoSideEffect && proposal.update.isEmpty()) {
            waitForNoSideEffect = false;
        }
        PaxosPropose<T> propose = new PaxosPropose<T>(proposal, participants.sizeOfPoll(), participants.sizeOfConsensusQuorum, waitForNoSideEffect, onDone);
        propose.start(participants);
        return onDone;
    }

    void start(Paxos.Participants participants) {
        Message<Request> message = Message.out(Verb.PAXOS2_PROPOSE_REQ, new Request(this.proposal));
        boolean executeOnSelf = false;
        int size = participants.sizeOfPoll();
        for (int i = 0; i < size; ++i) {
            InetAddressAndPort destination = participants.voter(i);
            logger.trace("{} to {}", (Object)this.proposal, (Object)destination);
            if (PaxosPropose.shouldExecuteOnSelf(destination)) {
                executeOnSelf = true;
                continue;
            }
            MessagingService.instance().sendWithCallback(message, destination, this);
        }
        if (executeOnSelf) {
            Verb.PAXOS2_PROPOSE_REQ.stage.execute(() -> this.executeOnSelf(this.proposal));
        }
    }

    Status status() {
        long responses = this.responses;
        if (this.isSuccessful(responses)) {
            return success;
        }
        if (!this.canSucceed(responses) && this.supersededBy != null) {
            Superseded.SideEffects sideEffects = this.hasNoSideEffects(responses) ? Superseded.SideEffects.NO : Superseded.SideEffects.MAYBE;
            return new Superseded(this.supersededBy, sideEffects);
        }
        return new MaybeFailure(new Paxos.MaybeFailure(this.participants, this.required, PaxosPropose.accepts(responses), this.failureReasonsAsMap()));
    }

    private void executeOnSelf(Commit.Proposal proposal) {
        this.executeOnSelf(proposal, RequestHandler::execute);
    }

    @Override
    public void onResponse(Response response, InetAddressAndPort from) {
        Ballot supersededBy;
        if (logger.isTraceEnabled()) {
            logger.trace("{} for {} from {}", new Object[]{response, this.proposal, from});
        }
        if ((supersededBy = response.supersededBy) != null) {
            supersededByUpdater.accumulateAndGet(this, supersededBy, (a, b) -> a == null ? b : (b.uuidTimestamp() > a.uuidTimestamp() ? b : a));
        }
        long increment = supersededBy == null ? 1L : 0x200000L;
        this.update(increment);
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} {} failure from {}", new Object[]{this.proposal, reason, from});
        }
        super.onFailure(from, reason);
        this.update(0x40000000000L);
    }

    private void update(long increment) {
        long responses = responsesUpdater.addAndGet(this, increment);
        if (this.shouldSignal(responses)) {
            this.signalDone();
        }
    }

    private boolean shouldSignal(long responses) {
        return PaxosPropose.shouldSignal(responses, this.required, this.participants, this.waitForNoSideEffect, responsesUpdater, this);
    }

    @VisibleForTesting
    public static <T> boolean shouldSignal(long responses, int required, int participants, boolean waitForNoSideEffect, AtomicLongFieldUpdater<T> responsesUpdater, T update) {
        if (responses <= 0L) {
            return false;
        }
        if (!PaxosPropose.isSuccessful(responses, required)) {
            if (PaxosPropose.canSucceed(responses, required, participants)) {
                return false;
            }
            if (waitForNoSideEffect && !PaxosPropose.hasPossibleSideEffects(responses)) {
                return PaxosPropose.hasNoSideEffects(responses, participants);
            }
        }
        return responsesUpdater.getAndUpdate(update, x -> x | Long.MIN_VALUE) >= 0L;
    }

    private void signalDone() {
        if (this.onDone != null) {
            this.onDone.accept((Status)this.status());
        }
    }

    private boolean isSuccessful(long responses) {
        return PaxosPropose.isSuccessful(responses, this.required);
    }

    private static boolean isSuccessful(long responses, int required) {
        return PaxosPropose.accepts(responses) >= required;
    }

    private boolean canSucceed(long responses) {
        return PaxosPropose.canSucceed(responses, this.required, this.participants);
    }

    private static boolean canSucceed(long responses, int required, int participants) {
        return PaxosPropose.refusals(responses) == 0 && required <= participants - PaxosPropose.failures(responses);
    }

    private boolean hasNoSideEffects(long responses) {
        return PaxosPropose.hasNoSideEffects(responses, this.participants);
    }

    private static boolean hasNoSideEffects(long responses, int participants) {
        return PaxosPropose.refusals(responses) == participants;
    }

    private static boolean hasPossibleSideEffects(long responses) {
        return PaxosPropose.accepts(responses) + PaxosPropose.failures(responses) > 0;
    }

    private static int accepts(long responses) {
        return (int)(responses & 0x1FFFFFL);
    }

    private static int notAccepts(long responses) {
        return PaxosPropose.failures(responses) + PaxosPropose.refusals(responses);
    }

    private static int refusals(long responses) {
        return (int)(responses >>> 21 & 0x1FFFFFL);
    }

    private static int failures(long responses) {
        return (int)(responses >>> 42 & 0x1FFFFFL);
    }

    /* synthetic */ PaxosPropose(Commit.Proposal x0, int x1, int x2, boolean x3, Consumer x4, 1 x5) {
        this(x0, x1, x2, x3, x4);
    }

    public static class ResponseSerializer
    implements IVersionedSerializer<Response> {
        @Override
        public void serialize(Response response, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(response.supersededBy != null);
            if (response.supersededBy != null) {
                response.supersededBy.serialize(out);
            }
        }

        @Override
        public Response deserialize(DataInputPlus in, int version) throws IOException {
            boolean isSuperseded = in.readBoolean();
            return isSuperseded ? new Response(Ballot.deserialize(in)) : new Response(null);
        }

        @Override
        public long serializedSize(Response response, int version) {
            return response.supersededBy != null ? (long)TypeSizes.sizeof(true) + Ballot.sizeInBytes() : (long)TypeSizes.sizeof(false);
        }
    }

    public static class RequestSerializer
    implements IVersionedSerializer<Request> {
        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            Commit.Proposal.serializer.serialize(request.proposal, out, version);
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            Commit.Proposal propose = (Commit.Proposal)Commit.Proposal.serializer.deserialize(in, version);
            return new Request(propose);
        }

        @Override
        public long serializedSize(Request request, int version) {
            return Commit.Proposal.serializer.serializedSize(request.proposal, version);
        }
    }

    public static class RequestHandler
    implements IVerbHandler<Request> {
        @Override
        public void doVerb(Message<Request> message) {
            Response response = RequestHandler.execute(((Request)message.payload).proposal, message.from());
            if (response == null) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
            } else {
                MessagingService.instance().respond(response, message);
            }
        }

        /*
         * Loose catch block
         */
        public static Response execute(Commit.Proposal proposal, InetAddressAndPort from) {
            if (!Paxos.isInRangeAndShouldProcess(from, proposal.update.partitionKey(), proposal.update.metadata(), false)) {
                return null;
            }
            long start = Clock.Global.nanoTime();
            try {
                try (PaxosState state = PaxosState.get(proposal);){
                    Response response = new Response(state.acceptIfLatest(proposal));
                    return response;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Keyspace.openAndGetStore((TableMetadata)proposal.update.metadata()).metric.casPropose.addNano(Clock.Global.nanoTime() - start);
            }
        }
    }

    static class Response {
        final Ballot supersededBy;

        Response(Ballot supersededBy) {
            this.supersededBy = supersededBy;
        }

        public String toString() {
            return this.supersededBy == null ? "Accept" : "RejectProposal(supersededBy=" + this.supersededBy + ')';
        }
    }

    static class Request {
        final Commit.Proposal proposal;

        Request(Commit.Proposal proposal) {
            this.proposal = proposal;
        }

        public String toString() {
            return this.proposal.toString("Propose");
        }
    }

    private static class MaybeFailure
    extends Status {
        final Paxos.MaybeFailure info;

        MaybeFailure(Paxos.MaybeFailure info) {
            super(Status.Outcome.MAYBE_FAILURE);
            this.info = info;
        }

        @Override
        public String toString() {
            return this.info.toString();
        }
    }

    static class Superseded
    extends Status {
        final Ballot by;
        final SideEffects hadSideEffects;

        Superseded(Ballot by, SideEffects hadSideEffects) {
            super(Status.Outcome.SUPERSEDED);
            this.by = by;
            this.hadSideEffects = hadSideEffects;
        }

        @Override
        public String toString() {
            return "Superseded(" + this.by + ',' + (Object)((Object)this.hadSideEffects) + ')';
        }

        static enum SideEffects {
            NO,
            MAYBE;

        }
    }

    static class Status {
        final Outcome outcome;

        Status(Outcome outcome) {
            this.outcome = outcome;
        }

        Superseded superseded() {
            return (Superseded)this;
        }

        Paxos.MaybeFailure maybeFailure() {
            return ((MaybeFailure)this).info;
        }

        public String toString() {
            return "Success";
        }

        static enum Outcome {
            SUCCESS,
            SUPERSEDED,
            MAYBE_FAILURE;

        }
    }
}

