/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaCloudSnitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(AlibabaCloudSnitch.class);
    protected static final String ZONE_NAME_QUERY_URL = "http://100.100.100.200/latest/meta-data/zone-id";
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    private Map<InetAddressAndPort, Map<String, String>> savedEndpoints;
    protected String ecsZone;
    protected String ecsRegion;
    private static final int HTTP_CONNECT_TIMEOUT = 30000;

    public AlibabaCloudSnitch() throws MalformedURLException, IOException {
        String response = this.alibabaApiCall(ZONE_NAME_QUERY_URL);
        String[] splits = response.split("/");
        String az = splits[splits.length - 1];
        splits = az.split("-");
        this.ecsZone = splits[splits.length - 1];
        int lastRegionIndex = az.lastIndexOf("-");
        this.ecsRegion = az.substring(0, lastRegionIndex);
        String datacenterSuffix = new SnitchProperties().get("dc_suffix", "");
        this.ecsRegion = this.ecsRegion.concat(datacenterSuffix);
        logger.info("AlibabaSnitch using region: {}, zone: {}.", (Object)this.ecsRegion, (Object)this.ecsZone);
    }

    String alibabaApiCall(String url) throws ConfigurationException, IOException, SocketTimeoutException {
        String string;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        DataInputStream d = null;
        try {
            conn.setConnectTimeout(30000);
            conn.setRequestMethod("GET");
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new ConfigurationException("AlibabaSnitch was unable to execute the API call. Not an ecs node? and the returun code is " + code);
            }
            int cl = conn.getContentLength();
            byte[] b = new byte[cl];
            d = new DataInputStream((FilterInputStream)conn.getContent());
            d.readFully(b);
            string = new String(b, StandardCharsets.UTF_8);
        }
        catch (SocketTimeoutException e) {
            try {
                throw new SocketTimeoutException("Timeout occurred reading a response from the Alibaba ECS metadata");
            }
            catch (Throwable throwable) {
                FileUtils.close(d);
                conn.disconnect();
                throw throwable;
            }
        }
        FileUtils.close(d);
        conn.disconnect();
        return string;
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.ecsZone;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.ecsRegion;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }
}

