/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.addsnowflakeid;

import java.util.concurrent.ThreadLocalRandom;

public class SnowflakeSafeIdGenerator {
    private static final long START_EPOCH = 1577836800000L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MACHINE_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long MAX_MACHINE_ID = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private final long dataCenterId;
    private final long machineId;
    private final long maxBackwardsMs;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long logicalTimestamp = -1L;

    public SnowflakeSafeIdGenerator(long dataCenterId, long machineId) {
        this(dataCenterId, machineId, 10L);
    }

    public SnowflakeSafeIdGenerator(long dataCenterId, long machineId, long maxBackwardsMs) {
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId out of range");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId out of range");
        }
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
        this.maxBackwardsMs = maxBackwardsMs;
    }

    public static SnowflakeSafeIdGenerator createDefault() {
        long dataCenterId = ThreadLocalRandom.current().nextInt(0, 32);
        long machineId = ThreadLocalRandom.current().nextInt(0, 32);
        return new SnowflakeSafeIdGenerator(dataCenterId, machineId, 10L);
    }

    public synchronized long nextId() {
        long now = this.currentTimeMillis();
        if (now < this.lastTimestamp) {
            long offset = this.lastTimestamp - now;
            if (offset <= this.maxBackwardsMs) {
                now = this.lastTimestamp;
            } else {
                throw new IllegalArgumentException("Clock moved backwards beyond tolerance. Refusing for " + offset + "ms");
            }
        }
        if (now == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                now = this.waitUntilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = now;
        this.logicalTimestamp = Math.max(now, this.logicalTimestamp + 1L);
        return this.logicalTimestamp - 1577836800000L << 22 | this.dataCenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long waitUntilNextMillis(long lastTime) {
        long ts = this.currentTimeMillis();
        while (ts <= lastTime) {
            ts = this.currentTimeMillis();
        }
        return ts;
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

