/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoCollection
extends GeoObject {
    private final List<GeoObject> geometries;

    public GeoCollection(List<GeoObject> geometries) {
        this(geometries, null, null);
    }

    public GeoCollection(List<GeoObject> geometries, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(geometries, "'geometries' cannot be null.");
        this.geometries = Collections.unmodifiableList(new ArrayList<GeoObject>(geometries));
    }

    public List<GeoObject> getGeometries() {
        return this.geometries;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.GEOMETRY_COLLECTION;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.geometries, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoCollection other = (GeoCollection)obj;
        return super.equals(other) && Objects.equals(this.geometries, other.geometries);
    }
}

