/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class ComparatorSyntaxChecker
extends SyntaxChecker {
    public static final ComparatorSyntaxChecker INSTANCE = new ComparatorSyntaxChecker("1.3.6.1.4.1.18060.0.4.1.0.5");

    private ComparatorSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return true;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        boolean result = Strings.isIA5String((String)strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
            } else {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<ComparatorSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.1.0.5");
        }

        @Override
        public ComparatorSyntaxChecker build() {
            return new ComparatorSyntaxChecker(this.oid);
        }
    }
}

