/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive.util;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class CustomLocalServerReceiver
implements VerificationCodeReceiver {
    private Server server;
    String code;
    String error;
    private int port;
    private final String host;
    private String url;

    public CustomLocalServerReceiver() {
        this("localhost", -1);
    }

    CustomLocalServerReceiver(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRedirectUri() throws IOException {
        if (this.port == -1) {
            this.port = CustomLocalServerReceiver.getUnusedPort();
        }
        this.server = new Server(this.port);
        InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
        this.server = new Server(socketAddress);
        this.server.setHandler((Handler)new CallbackHandler());
        try {
            this.server.start();
        }
        catch (Exception var5) {
            Throwables.propagateIfPossible((Throwable)var5);
            throw new IOException(var5);
        }
        return "http://" + this.host + ":" + this.port + "/Callback/success.html";
    }

    public String waitForCode() throws IOException {
        return this.code;
    }

    public void stop() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception var2) {
                Throwables.propagateIfPossible((Throwable)var2);
                throw new IOException(var2);
            }
            this.server = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static int getUnusedPort() throws IOException {
        int var1;
        s.bind(null);
        try (Socket s = new Socket();){
            var1 = s.getLocalPort();
        }
        return var1;
    }

    class CallbackHandler
    extends WebAppContext {
        CallbackHandler() {
            URL warUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("success_page");
            String warUrlString = warUrl.toExternalForm();
            this.setBaseResource(ResourceFactory.of((Container)this).newResource(warUrlString));
            this.setContextPath("/Callback");
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            String pathInContext = request.getHttpURI().getPath();
            if (pathInContext.contains("/Callback")) {
                Fields params = Request.extractQueryParameters((Request)request);
                CustomLocalServerReceiver.this.error = params.getValue("error");
                if (CustomLocalServerReceiver.this.code == null) {
                    CustomLocalServerReceiver.this.code = params.getValue("code");
                }
                if (CustomLocalServerReceiver.this.url != null && CustomLocalServerReceiver.this.error != null && CustomLocalServerReceiver.this.error.equals("access_denied")) {
                    Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)CustomLocalServerReceiver.this.url);
                } else {
                    return super.handle(request, response, callback);
                }
            }
            callback.succeeded();
            return true;
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = -1;

        public CustomLocalServerReceiver build() {
            return new CustomLocalServerReceiver(this.host, this.port);
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }
    }
}

