/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.flink;

import java.util.Arrays;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamFlinkPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    @GuiWidgetElement(order="20010-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsMaster.Label", toolTip="i18n::BeamEnginesFlink.OptionsMaster.ToolTip")
    @HopMetadataProperty
    private String flinkMaster;
    @GuiWidgetElement(order="20020-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsParallelism.Label", toolTip="i18n::BeamEnginesFlink.OptionsParallelism.ToolTip")
    @HopMetadataProperty
    private String flinkParallelism;
    @GuiWidgetElement(order="20030-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsCheckpointInterval.Label", toolTip="i18n::BeamEnginesFlink.OptionsCheckpointInterval.ToolTip")
    @HopMetadataProperty
    private String flinkCheckpointingInterval;
    @GuiWidgetElement(order="20040-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsCheckpointMode.Label", toolTip="i18n::BeamEnginesFlink.OptionsCheckpointMode.ToolTip")
    @HopMetadataProperty
    private String flinkCheckpointingMode;
    @GuiWidgetElement(order="20050-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsCheckpointTimeout.Label", toolTip="i18n::BeamEnginesFlink.OptionsCheckpointTimeout.ToolTip")
    @HopMetadataProperty
    private String flinkCheckpointTimeoutMillis;
    @GuiWidgetElement(order="20060-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsPauseBetweenCheckpoints.Label", toolTip="i18n::BeamEnginesFlink.OptionsPauseBetweenCheckpoints.ToolTip")
    @HopMetadataProperty
    private String flinkMinPauseBetweenCheckpoints;
    @GuiWidgetElement(order="20070-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsFailOnCheckpointErrors.Label", toolTip="i18n::BeamEnginesFlink.OptionsFailOnCheckpointErrors.ToolTip")
    @HopMetadataProperty
    private String flinkFailingOnCheckpointingErrors;
    @GuiWidgetElement(order="20080-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsNumberOfRetries.Label", toolTip="i18n::BeamEnginesFlink.OptionsNumberOfRetries.ToolTip")
    @HopMetadataProperty
    private String flinkNumberOfExecutionRetries;
    @GuiWidgetElement(order="20090-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsRetryDelay.Label", toolTip="i18n::BeamEnginesFlink.OptionsRetryDelay.ToolTip")
    @HopMetadataProperty
    private String flinkExecutionRetryDelay;
    @GuiWidgetElement(order="20100-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsObjectReuse.Label", toolTip="i18n::BeamEnginesFlink.OptionsObjectReuse.ToolTip")
    @HopMetadataProperty
    private String flinkObjectReuse;
    @GuiWidgetElement(order="20110-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsDisableMetrics.Label", toolTip="i18n::BeamEnginesFlink.OptionsDisableMetrics.ToolTip")
    @HopMetadataProperty
    private String flinkDisableMetrics;
    @GuiWidgetElement(order="20120-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsExternalizedCheckpointsEnabled.Label", toolTip="i18n::BeamEnginesFlink.OptionsExternalizedCheckpointsEnabled.ToolTip")
    @HopMetadataProperty
    private String flinkExternalizedCheckpointsEnabled;
    @GuiWidgetElement(order="20130-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsRetainExternalizedCheckpointsOnCancellation.Label", toolTip="i18n::BeamEnginesFlink.OptionsRetainExternalizedCheckpointsOnCancellation.ToolTip")
    @HopMetadataProperty
    private String flinkRetainExternalizedCheckpointsOnCancellation;
    @GuiWidgetElement(order="20140-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsMaxBundleSize.Label", toolTip="i18n::BeamEnginesFlink.OptionsMaxBundleSize.ToolTip")
    @HopMetadataProperty
    private String flinkMaxBundleSize;
    @GuiWidgetElement(order="20150-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsMaxBundleTimeMills.Label", toolTip="i18n::BeamEnginesFlink.OptionsMaxBundleTimeMills.ToolTip")
    @HopMetadataProperty
    private String flinkMaxBundleTimeMills;
    @GuiWidgetElement(order="20160-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsShutdownSourcesAfterIdleMs.Label", toolTip="i18n::BeamEnginesFlink.OptionsShutdownSourcesAfterIdleMs.ToolTip")
    @HopMetadataProperty
    private String flinkShutdownSourcesAfterIdleMs;
    @GuiWidgetElement(order="20170-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsLatencyTrackingInterval.Label", toolTip="i18n::BeamEnginesFlink.OptionsLatencyTrackingInterval.ToolTip")
    @HopMetadataProperty
    private String flinkLatencyTrackingInterval;
    @GuiWidgetElement(order="20180-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsAutoWatermarkInterval.Label", toolTip="i18n::BeamEnginesFlink.OptionsAutoWatermarkInterval.ToolTip")
    @HopMetadataProperty
    private String flinkAutoWatermarkInterval;
    @GuiWidgetElement(order="20190-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesFlink.OptionsExecutionModeForBatch.Label", toolTip="i18n::BeamEnginesFlink.OptionsExecutionModeForBatch.ToolTip")
    @HopMetadataProperty
    private String flinkExecutionModeForBatch;

    public BeamFlinkPipelineRunConfiguration() {
        this.tempLocation = "file://" + System.getProperty("java.io.tmpdir");
    }

    public BeamFlinkPipelineRunConfiguration(String flinkMaster, String flinkParallelism) {
        this();
        this.flinkMaster = flinkMaster;
        this.flinkParallelism = flinkParallelism;
    }

    public BeamFlinkPipelineRunConfiguration(BeamFlinkPipelineRunConfiguration config) {
        super(config);
        this.flinkMaster = config.flinkMaster;
        this.flinkParallelism = config.flinkParallelism;
        this.flinkCheckpointingInterval = config.flinkCheckpointingInterval;
        this.flinkCheckpointingMode = config.flinkCheckpointingMode;
        this.flinkCheckpointTimeoutMillis = config.flinkCheckpointTimeoutMillis;
        this.flinkMinPauseBetweenCheckpoints = config.flinkMinPauseBetweenCheckpoints;
        this.flinkFailingOnCheckpointingErrors = config.flinkFailingOnCheckpointingErrors;
        this.flinkNumberOfExecutionRetries = config.flinkNumberOfExecutionRetries;
        this.flinkExecutionRetryDelay = config.flinkExecutionRetryDelay;
        this.flinkObjectReuse = config.flinkObjectReuse;
        this.flinkDisableMetrics = config.flinkDisableMetrics;
        this.flinkExternalizedCheckpointsEnabled = config.flinkExternalizedCheckpointsEnabled;
        this.flinkRetainExternalizedCheckpointsOnCancellation = config.flinkRetainExternalizedCheckpointsOnCancellation;
        this.flinkMaxBundleSize = config.flinkMaxBundleSize;
        this.flinkMaxBundleTimeMills = config.flinkMaxBundleTimeMills;
        this.flinkShutdownSourcesAfterIdleMs = config.flinkShutdownSourcesAfterIdleMs;
        this.flinkLatencyTrackingInterval = config.flinkLatencyTrackingInterval;
        this.flinkAutoWatermarkInterval = config.flinkAutoWatermarkInterval;
        this.flinkExecutionModeForBatch = config.flinkExecutionModeForBatch;
    }

    public BeamFlinkPipelineRunConfiguration clone() {
        return new BeamFlinkPipelineRunConfiguration(this);
    }

    public RunnerType getRunnerType() {
        return RunnerType.Flink;
    }

    public PipelineOptions getPipelineOptions() throws HopException {
        try {
            long value;
            long value2;
            long value3;
            long value4;
            long value5;
            long value6;
            long value7;
            CheckpointingMode mode;
            long value8;
            int value9;
            FlinkPipelineOptions options = (FlinkPipelineOptions)PipelineOptionsFactory.as(FlinkPipelineOptions.class);
            if (StringUtils.isNotEmpty((String)this.getFlinkMaster())) {
                options.setFlinkMaster(this.resolve(this.getFlinkMaster()));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkParallelism()) && (value9 = Const.toInt((String)this.resolve(this.getFlinkParallelism()), (int)-1)) > 0) {
                options.setParallelism(Integer.valueOf(value9));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointingInterval()) && (value8 = Const.toLong((String)this.resolve(this.getFlinkCheckpointingInterval()), (long)-1L)) > 0L) {
                options.setCheckpointingInterval(Long.valueOf(value8));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointingMode())) {
                String modeString = this.resolve(this.getFlinkCheckpointingMode());
                try {
                    mode = CheckpointingMode.valueOf((String)modeString);
                    options.setCheckpointingMode(modeString);
                }
                catch (Exception e) {
                    throw new HopException("Unable to parse flink check pointing mode '" + modeString + "'", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkCheckpointTimeoutMillis()) && (value7 = Const.toLong((String)this.resolve(this.getFlinkCheckpointTimeoutMillis()), (long)-1L)) > 0L) {
                options.setCheckpointTimeoutMillis(Long.valueOf(value7));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMinPauseBetweenCheckpoints()) && (value6 = Const.toLong((String)this.resolve(this.getFlinkMinPauseBetweenCheckpoints()), (long)-1L)) > 0L) {
                options.setMinPauseBetweenCheckpoints(Long.valueOf(value6));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkNumberOfExecutionRetries()) && (value9 = Const.toInt((String)this.resolve(this.getFlinkNumberOfExecutionRetries()), (int)-1)) >= 0) {
                options.setNumberOfExecutionRetries(Integer.valueOf(value9));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExecutionRetryDelay()) && (value5 = Const.toLong((String)this.resolve(this.getFlinkExecutionRetryDelay()), (long)-1L)) > 0L) {
                options.setExecutionRetryDelay(Long.valueOf(value5));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkObjectReuse())) {
                String str = this.resolve(this.getFlinkObjectReuse());
                boolean value10 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setObjectReuse(Boolean.valueOf(value10));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkDisableMetrics())) {
                String str = this.resolve(this.getFlinkDisableMetrics());
                boolean value11 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setDisableMetrics(Boolean.valueOf(!value11));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExternalizedCheckpointsEnabled())) {
                String str = this.resolve(this.getFlinkExternalizedCheckpointsEnabled());
                boolean value12 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setExternalizedCheckpointsEnabled(Boolean.valueOf(value12));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkRetainExternalizedCheckpointsOnCancellation())) {
                String str = this.resolve(this.getFlinkRetainExternalizedCheckpointsOnCancellation());
                boolean value13 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setRetainExternalizedCheckpointsOnCancellation(Boolean.valueOf(value13));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMaxBundleSize()) && (value4 = Const.toLong((String)this.resolve(this.getFlinkMaxBundleSize()), (long)-1L)) > 0L) {
                options.setMaxBundleSize(Long.valueOf(value4));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkMaxBundleTimeMills()) && (value3 = Const.toLong((String)this.resolve(this.getFlinkMaxBundleTimeMills()), (long)-1L)) > 0L) {
                options.setMaxBundleSize(Long.valueOf(value3));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkFailingOnCheckpointingErrors())) {
                String str = this.resolve(this.getFlinkFailingOnCheckpointingErrors());
                boolean value14 = "Y".equalsIgnoreCase(str) || "TRUE".equalsIgnoreCase(str);
                options.setFailOnCheckpointingErrors(Boolean.valueOf(value14));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkShutdownSourcesAfterIdleMs())) {
                String str = this.resolve(this.getFlinkShutdownSourcesAfterIdleMs());
                long value15 = Const.toLong((String)str, (long)-1L);
                options.setShutdownSourcesAfterIdleMs(Long.valueOf(value15));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkLatencyTrackingInterval()) && (value2 = Const.toLong((String)this.resolve(this.getFlinkLatencyTrackingInterval()), (long)-1L)) > 0L) {
                options.setLatencyTrackingInterval(Long.valueOf(value2));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkAutoWatermarkInterval()) && (value = Const.toLong((String)this.resolve(this.getFlinkAutoWatermarkInterval()), (long)-1L)) > 0L) {
                options.setAutoWatermarkInterval(Long.valueOf(value));
            }
            if (StringUtils.isNotEmpty((String)this.getFlinkExecutionModeForBatch())) {
                String modeString = this.resolve(this.getFlinkExecutionModeForBatch());
                mode = ExecutionMode.valueOf((String)modeString);
                try {
                    options.setExecutionModeForBatch(modeString);
                }
                catch (Exception e) {
                    throw new HopException("Unable to parse flink execution mode for batch '" + modeString + "'", (Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty((String)this.getFatJar())) {
                options.setFilesToStage(Arrays.asList(this.resolve(this.fatJar)));
            }
            return options;
        }
        catch (Throwable e) {
            throw new HopException("Error building Flink pipeline options", e);
        }
    }

    public boolean isRunningAsynchronous() {
        return true;
    }

    public String getFlinkMaster() {
        return this.flinkMaster;
    }

    public void setFlinkMaster(String flinkMaster) {
        this.flinkMaster = flinkMaster;
    }

    public String getFlinkParallelism() {
        return this.flinkParallelism;
    }

    public void setFlinkParallelism(String flinkParallelism) {
        this.flinkParallelism = flinkParallelism;
    }

    public String getFlinkCheckpointingInterval() {
        return this.flinkCheckpointingInterval;
    }

    public void setFlinkCheckpointingInterval(String flinkCheckpointingInterval) {
        this.flinkCheckpointingInterval = flinkCheckpointingInterval;
    }

    public String getFlinkCheckpointingMode() {
        return this.flinkCheckpointingMode;
    }

    public void setFlinkCheckpointingMode(String flinkCheckpointingMode) {
        this.flinkCheckpointingMode = flinkCheckpointingMode;
    }

    public String getFlinkCheckpointTimeoutMillis() {
        return this.flinkCheckpointTimeoutMillis;
    }

    public void setFlinkCheckpointTimeoutMillis(String flinkCheckpointTimeoutMillis) {
        this.flinkCheckpointTimeoutMillis = flinkCheckpointTimeoutMillis;
    }

    public String getFlinkMinPauseBetweenCheckpoints() {
        return this.flinkMinPauseBetweenCheckpoints;
    }

    public void setFlinkMinPauseBetweenCheckpoints(String flinkMinPauseBetweenCheckpoints) {
        this.flinkMinPauseBetweenCheckpoints = flinkMinPauseBetweenCheckpoints;
    }

    public String getFlinkFailingOnCheckpointingErrors() {
        return this.flinkFailingOnCheckpointingErrors;
    }

    public void setFlinkFailingOnCheckpointingErrors(String flinkFailingOnCheckpointingErrors) {
        this.flinkFailingOnCheckpointingErrors = flinkFailingOnCheckpointingErrors;
    }

    public String getFlinkNumberOfExecutionRetries() {
        return this.flinkNumberOfExecutionRetries;
    }

    public void setFlinkNumberOfExecutionRetries(String flinkNumberOfExecutionRetries) {
        this.flinkNumberOfExecutionRetries = flinkNumberOfExecutionRetries;
    }

    public String getFlinkExecutionRetryDelay() {
        return this.flinkExecutionRetryDelay;
    }

    public void setFlinkExecutionRetryDelay(String flinkExecutionRetryDelay) {
        this.flinkExecutionRetryDelay = flinkExecutionRetryDelay;
    }

    public String getFlinkObjectReuse() {
        return this.flinkObjectReuse;
    }

    public void setFlinkObjectReuse(String flinkObjectReuse) {
        this.flinkObjectReuse = flinkObjectReuse;
    }

    public String getFlinkDisableMetrics() {
        return this.flinkDisableMetrics;
    }

    public void setFlinkDisableMetrics(String flinkDisableMetrics) {
        this.flinkDisableMetrics = flinkDisableMetrics;
    }

    public String getFlinkExternalizedCheckpointsEnabled() {
        return this.flinkExternalizedCheckpointsEnabled;
    }

    public void setFlinkExternalizedCheckpointsEnabled(String flinkExternalizedCheckpointsEnabled) {
        this.flinkExternalizedCheckpointsEnabled = flinkExternalizedCheckpointsEnabled;
    }

    public String getFlinkRetainExternalizedCheckpointsOnCancellation() {
        return this.flinkRetainExternalizedCheckpointsOnCancellation;
    }

    public void setFlinkRetainExternalizedCheckpointsOnCancellation(String flinkRetainExternalizedCheckpointsOnCancellation) {
        this.flinkRetainExternalizedCheckpointsOnCancellation = flinkRetainExternalizedCheckpointsOnCancellation;
    }

    public String getFlinkMaxBundleSize() {
        return this.flinkMaxBundleSize;
    }

    public void setFlinkMaxBundleSize(String flinkMaxBundleSize) {
        this.flinkMaxBundleSize = flinkMaxBundleSize;
    }

    public String getFlinkMaxBundleTimeMills() {
        return this.flinkMaxBundleTimeMills;
    }

    public void setFlinkMaxBundleTimeMills(String flinkMaxBundleTimeMills) {
        this.flinkMaxBundleTimeMills = flinkMaxBundleTimeMills;
    }

    public String getFlinkShutdownSourcesAfterIdleMs() {
        return this.flinkShutdownSourcesAfterIdleMs;
    }

    public void setFlinkShutdownSourcesAfterIdleMs(String flinkShutdownSourcesAfterIdleMs) {
        this.flinkShutdownSourcesAfterIdleMs = flinkShutdownSourcesAfterIdleMs;
    }

    public String getFlinkLatencyTrackingInterval() {
        return this.flinkLatencyTrackingInterval;
    }

    public void setFlinkLatencyTrackingInterval(String flinkLatencyTrackingInterval) {
        this.flinkLatencyTrackingInterval = flinkLatencyTrackingInterval;
    }

    public String getFlinkAutoWatermarkInterval() {
        return this.flinkAutoWatermarkInterval;
    }

    public void setFlinkAutoWatermarkInterval(String flinkAutoWatermarkInterval) {
        this.flinkAutoWatermarkInterval = flinkAutoWatermarkInterval;
    }

    public String getFlinkExecutionModeForBatch() {
        return this.flinkExecutionModeForBatch;
    }

    public void setFlinkExecutionModeForBatch(String flinkExecutionModeForBatch) {
        this.flinkExecutionModeForBatch = flinkExecutionModeForBatch;
    }
}

