/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RegexEvalHelperDialog
extends Dialog {
    private static final Class<?> PKG = RegexEvalMeta.class;
    private final IVariables variables;
    private Shell shell;
    private String regexScript;
    private final String regexOptions;
    private final boolean canonicalEqualityFlagSet;
    private StyledTextComp wRegExScript;
    private Label wIconValue1;
    private Text wValue1;
    private Label wIconValue2;
    private Text wValue2;
    private Label wIconValue3;
    private Text wValue3;
    private Text wRegExScriptCompile;
    private List wGroups;
    private Label wlGroups;
    private Label wIconValueGroup;
    private Text wValueGroup;
    private boolean errorDisplayed;

    public RegexEvalHelperDialog(Shell parent, IVariables variables, String regexScript, String regexOptions, boolean canonicalEqualityFlagSet) {
        super(parent, 0);
        this.variables = variables;
        this.regexScript = regexScript;
        this.regexOptions = regexOptions;
        this.errorDisplayed = false;
        this.canonicalEqualityFlagSet = canonicalEqualityFlagSet;
    }

    private boolean isCanonicalEqualityFlagSet() {
        return this.canonicalEqualityFlagSet;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Shell.Label", (String[])new String[0]));
        int margin = PropsUi.getMargin();
        int middle = 30;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlRegExScript = new Label((Composite)this.shell, 16384);
        wlRegExScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRegExScript);
        FormData fdlRegExScript = new FormData();
        fdlRegExScript.left = new FormAttachment(0, 0);
        fdlRegExScript.right = new FormAttachment(100, 0);
        fdlRegExScript.top = new FormAttachment(0, 2 * margin);
        wlRegExScript.setLayoutData((Object)fdlRegExScript);
        this.wRegExScript = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        PropsUi.setLook((Widget)this.wRegExScript);
        FormData fdRegExScript = new FormData();
        fdRegExScript.left = new FormAttachment(0, 0);
        fdRegExScript.top = new FormAttachment((Control)wlRegExScript, 2 * margin);
        fdRegExScript.right = new FormAttachment(100, -margin);
        fdRegExScript.bottom = new FormAttachment(40, -2 * margin);
        this.wRegExScript.setLayoutData((Object)fdRegExScript);
        this.wRegExScript.setFont(GuiResource.getInstance().getFontFixed());
        this.wRegExScriptCompile = new Text((Composite)this.shell, 18946);
        PropsUi.setLook((Widget)this.wRegExScriptCompile, (int)1);
        FormData fdRegExScriptCompile = new FormData();
        fdRegExScriptCompile.left = new FormAttachment(0, 0);
        fdRegExScriptCompile.top = new FormAttachment((Control)this.wRegExScript, margin);
        fdRegExScriptCompile.right = new FormAttachment(100, 0);
        this.wRegExScriptCompile.setLayoutData((Object)fdRegExScriptCompile);
        this.wRegExScriptCompile.setEditable(false);
        this.wRegExScriptCompile.setFont(GuiResource.getInstance().getFontNote());
        Group wValuesGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wValuesGroup);
        wValuesGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.TestValues.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wValuesGroup.setLayout((Layout)groupLayout);
        Label wlValue1 = new Label((Composite)wValuesGroup, 131072);
        wlValue1.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value1.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue1);
        FormData fdlValue1 = new FormData();
        fdlValue1.left = new FormAttachment(0, 0);
        fdlValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdlValue1.right = new FormAttachment(middle, -margin);
        wlValue1.setLayoutData((Object)fdlValue1);
        this.wIconValue1 = new Label((Composite)wValuesGroup, 131072);
        this.wIconValue1.setImage(GuiResource.getInstance().getImageEdit());
        PropsUi.setLook((Widget)this.wIconValue1);
        FormData fdlIconValue1 = new FormData();
        fdlIconValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdlIconValue1.right = new FormAttachment(100, 0);
        this.wIconValue1.setLayoutData((Object)fdlIconValue1);
        this.wValue1 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue1);
        FormData fdValue1 = new FormData();
        fdValue1.left = new FormAttachment(middle, margin);
        fdValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdValue1.right = new FormAttachment((Control)this.wIconValue1, -margin);
        this.wValue1.setLayoutData((Object)fdValue1);
        Label wlValue2 = new Label((Composite)wValuesGroup, 131072);
        wlValue2.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value2.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue2);
        FormData fdlValue2 = new FormData();
        fdlValue2.left = new FormAttachment(0, 0);
        fdlValue2.top = new FormAttachment((Control)this.wValue1, margin);
        fdlValue2.right = new FormAttachment(middle, -margin);
        wlValue2.setLayoutData((Object)fdlValue2);
        this.wIconValue2 = new Label((Composite)wValuesGroup, 131072);
        this.wIconValue2.setImage(GuiResource.getInstance().getImageEdit());
        PropsUi.setLook((Widget)this.wIconValue2);
        FormData fdlIconValue2 = new FormData();
        fdlIconValue2.top = new FormAttachment((Control)this.wValue1, margin);
        fdlIconValue2.right = new FormAttachment(100, 0);
        this.wIconValue2.setLayoutData((Object)fdlIconValue2);
        this.wValue2 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue2);
        FormData fdValue2 = new FormData();
        fdValue2.left = new FormAttachment(middle, margin);
        fdValue2.top = new FormAttachment((Control)this.wValue1, margin);
        fdValue2.right = new FormAttachment((Control)this.wIconValue2, -margin);
        this.wValue2.setLayoutData((Object)fdValue2);
        Label wlValue3 = new Label((Composite)wValuesGroup, 131072);
        wlValue3.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value3.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValue3);
        FormData fdlValue3 = new FormData();
        fdlValue3.left = new FormAttachment(0, 0);
        fdlValue3.top = new FormAttachment((Control)this.wValue2, margin);
        fdlValue3.right = new FormAttachment(middle, -margin);
        wlValue3.setLayoutData((Object)fdlValue3);
        this.wIconValue3 = new Label((Composite)wValuesGroup, 131072);
        this.wIconValue3.setImage(GuiResource.getInstance().getImageEdit());
        PropsUi.setLook((Widget)this.wIconValue3);
        FormData fdlIconValue3 = new FormData();
        fdlIconValue3.top = new FormAttachment((Control)this.wValue2, margin);
        fdlIconValue3.right = new FormAttachment(100, 0);
        this.wIconValue3.setLayoutData((Object)fdlIconValue3);
        this.wValue3 = new Text((Composite)wValuesGroup, 18436);
        PropsUi.setLook((Widget)this.wValue3);
        FormData fdValue3 = new FormData();
        fdValue3.left = new FormAttachment(middle, margin);
        fdValue3.top = new FormAttachment((Control)this.wValue2, margin);
        fdValue3.right = new FormAttachment((Control)this.wIconValue3, -margin);
        this.wValue3.setLayoutData((Object)fdValue3);
        FormData fdValuesGroup = new FormData();
        fdValuesGroup.left = new FormAttachment(0, 0);
        fdValuesGroup.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        fdValuesGroup.right = new FormAttachment(100, 0);
        wValuesGroup.setLayoutData((Object)fdValuesGroup);
        Group wCaptureGroups = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wCaptureGroups);
        wCaptureGroups.setText("Capture");
        FormLayout captureLayout = new FormLayout();
        captureLayout.marginWidth = 10;
        captureLayout.marginHeight = 10;
        wCaptureGroups.setLayout((Layout)captureLayout);
        Label wlValueGroup = new Label((Composite)wCaptureGroups, 131072);
        wlValueGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ValueGroup.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValueGroup);
        FormData fdlValueGroup = new FormData();
        fdlValueGroup.left = new FormAttachment(0, 0);
        fdlValueGroup.top = new FormAttachment((Control)wValuesGroup, margin);
        fdlValueGroup.right = new FormAttachment(middle, -margin);
        wlValueGroup.setLayoutData((Object)fdlValueGroup);
        this.wIconValueGroup = new Label((Composite)wCaptureGroups, 131072);
        this.wIconValueGroup.setImage(GuiResource.getInstance().getImageEdit());
        PropsUi.setLook((Widget)this.wIconValueGroup);
        FormData fdlIconValueGroup = new FormData();
        fdlIconValueGroup.top = new FormAttachment((Control)wValuesGroup, margin);
        fdlIconValueGroup.right = new FormAttachment(100, 0);
        this.wIconValueGroup.setLayoutData((Object)fdlIconValueGroup);
        this.wValueGroup = new Text((Composite)wCaptureGroups, 18436);
        PropsUi.setLook((Widget)this.wValueGroup);
        FormData fdValueGroup = new FormData();
        fdValueGroup.left = new FormAttachment(middle, margin);
        fdValueGroup.top = new FormAttachment((Control)wValuesGroup, margin);
        fdValueGroup.right = new FormAttachment((Control)this.wIconValueGroup, -margin);
        this.wValueGroup.setLayoutData((Object)fdValueGroup);
        this.wlGroups = new Label((Composite)wCaptureGroups, 131072);
        this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.GroupFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlGroups);
        FormData fdlGroups = new FormData();
        fdlGroups.left = new FormAttachment(0, 0);
        fdlGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        fdlGroups.right = new FormAttachment(middle, -margin);
        this.wlGroups.setLayoutData((Object)fdlGroups);
        this.wGroups = new List((Composite)wCaptureGroups, 19204);
        PropsUi.setLook((Widget)this.wGroups);
        FormData fdGroups = new FormData();
        fdGroups.left = new FormAttachment(middle, margin);
        fdGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        fdGroups.right = new FormAttachment(100, -2 * margin - 16);
        fdGroups.bottom = new FormAttachment(100, -margin);
        this.wGroups.setLayoutData((Object)fdGroups);
        FormData fdCaptureGroups = new FormData();
        fdCaptureGroups.left = new FormAttachment(0, 0);
        fdCaptureGroups.top = new FormAttachment((Control)wValuesGroup, margin);
        fdCaptureGroups.right = new FormAttachment(100, 0);
        fdCaptureGroups.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wCaptureGroups.setLayoutData((Object)fdCaptureGroups);
        this.wValue1.addModifyListener(e -> this.testValue(1, true, null));
        this.wValue2.addModifyListener(e -> this.testValue(2, true, null));
        this.wValue3.addModifyListener(e -> this.testValue(3, true, null));
        this.wValueGroup.addModifyListener(e -> this.testValue(4, true, null));
        this.wRegExScript.addModifyListener(e -> {
            this.errorDisplayed = false;
            this.testValues();
        });
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.regexScript;
    }

    private void testValues() {
        String realScript = this.variables.resolve(this.wRegExScript.getText());
        for (int i = 1; i < 5; ++i) {
            this.testValue(i, false, realScript);
        }
    }

    private void testValue(int index, boolean testRegEx, String regExString) {
        block19: {
            Label control;
            String realValue;
            String realScript = regExString;
            if (realScript == null) {
                realScript = this.variables.resolve(this.wRegExScript.getText());
            }
            if (Utils.isEmpty((CharSequence)realScript)) {
                if (testRegEx) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Title", (String[])new String[0]));
                    mb.open();
                }
                return;
            }
            switch (index) {
                case 1: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue1.getText()), (String)"");
                    control = this.wIconValue1;
                    break;
                }
                case 2: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue2.getText()), (String)"");
                    control = this.wIconValue2;
                    break;
                }
                case 3: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValue3.getText()), (String)"");
                    control = this.wIconValue3;
                    break;
                }
                case 4: {
                    realValue = Const.NVL((String)this.variables.resolve(this.wValueGroup.getText()), (String)"");
                    control = this.wIconValueGroup;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                Pattern p = this.isCanonicalEqualityFlagSet() ? Pattern.compile(this.regexOptions + realScript, 128) : Pattern.compile(this.regexOptions + realScript);
                Matcher m = p.matcher(Const.NVL((String)realValue, (String)""));
                boolean isMatch = m.matches();
                if (Utils.isEmpty((CharSequence)realValue)) {
                    control.setImage(GuiResource.getInstance().getImageEdit());
                } else if (isMatch) {
                    control.setImage(GuiResource.getInstance().getImageTrue());
                } else {
                    control.setImage(GuiResource.getInstance().getImageFalse());
                }
                if (index == 4) {
                    this.wGroups.removeAll();
                    int nrFields = m.groupCount();
                    int nr = 0;
                    for (int i = 1; i <= nrFields; ++i) {
                        if (m.group(i) == null) {
                            this.wGroups.add("");
                        } else {
                            this.wGroups.add(m.group(i));
                        }
                        ++nr;
                    }
                    this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.FieldsGroup", (Object[])new Object[]{nr}));
                }
                this.wRegExScriptCompile.setForeground(GuiResource.getInstance().getColorDarkGreen());
                this.wRegExScriptCompile.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ScriptSuccessfullyCompiled", (String[])new String[0]));
                this.wRegExScriptCompile.setToolTipText("");
            }
            catch (Exception e) {
                if (this.errorDisplayed) break block19;
                this.wRegExScriptCompile.setForeground(GuiResource.getInstance().getColorDarkRed());
                this.wRegExScriptCompile.setText(e.getMessage());
                this.wRegExScriptCompile.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ErrorCompiling.Message", (String[])new String[0]) + Const.CR + String.valueOf(e));
                this.errorDisplayed = true;
            }
        }
    }

    public void dispose() {
        PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.regexScript != null) {
            this.wRegExScript.setText(this.regexScript);
        }
    }

    private void cancel() {
        this.dispose();
    }

    private void ok() {
        if (this.wRegExScript.getText() != null) {
            this.regexScript = this.wRegExScript.getText();
        }
        this.dispose();
    }
}

