/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.MP3Frame;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioFrame
implements MP3Frame {
    public static final int MPEG_V1 = 3;
    public static final int MPEG_V2 = 2;
    public static final int MPEG_V2_5 = 0;
    public static final int LAYER_1 = 3;
    public static final int LAYER_2 = 2;
    public static final int LAYER_3 = 1;
    private final String version;
    private final int versionCode;
    private final int layer;
    private final int sampleRate;
    private final int channels;
    private final int bitRate;
    private final int length;
    private final float duration;

    @Deprecated
    public AudioFrame(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        this(-2, -2, -2, -2, stream);
    }

    @Deprecated
    public AudioFrame(int h1, int h2, int h3, int h4, InputStream in) throws IOException {
        int rate;
        if (h1 == -2 && h2 == -2 && h3 == -2 && h4 == -2) {
            h1 = in.read();
            h2 = in.read();
            h3 = in.read();
            h4 = in.read();
        }
        if (AudioFrame.isAudioHeader(h1, h2, h3, h4)) {
            this.layer = h2 >> 1 & 3;
            this.versionCode = h2 >> 3 & 3;
            this.version = AudioFrame.generateVersionStr(this.versionCode, this.layer);
            int rateCode = h3 >> 2 & 3;
            switch (rateCode) {
                case 0: {
                    rate = 11025;
                    break;
                }
                case 1: {
                    rate = 12000;
                    break;
                }
                default: {
                    rate = 8000;
                }
            }
            if (this.versionCode == 2) {
                rate *= 2;
            } else if (this.versionCode == 3) {
                rate *= 4;
            }
        } else {
            throw new IllegalArgumentException("Magic Audio Frame Header not found");
        }
        this.sampleRate = rate;
        int chans = h4 & 0x192;
        this.channels = chans < 3 ? 2 : 1;
        this.bitRate = 0;
        this.duration = 0.0f;
        this.length = 0;
    }

    public AudioFrame(int mpegVersion, int layer, int bitRate, int sampleRate, int channels, int length, float duration) {
        this.versionCode = mpegVersion;
        this.layer = layer;
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.length = length;
        this.duration = duration;
        this.version = AudioFrame.generateVersionStr(mpegVersion, layer);
    }

    public static boolean isAudioHeader(int h1, int h2, int h3, int h4) {
        if (h1 == -1 || h2 == -1 || h3 == -1 || h4 == -1) {
            return false;
        }
        return h1 == 255 && (h2 & 0x60) == 96;
    }

    private static String generateVersionStr(int version, int layer) {
        StringBuilder buf = new StringBuilder(64);
        buf.append("MPEG 3 Layer ");
        if (layer == 1) {
            buf.append("III");
        } else if (layer == 2) {
            buf.append("II");
        } else if (layer == 3) {
            buf.append("I");
        } else {
            buf.append("(reserved)");
        }
        buf.append(" Version ");
        if (version == 0) {
            buf.append("2.5");
        } else if (version == 2) {
            buf.append("2");
        } else if (version == 3) {
            buf.append("1");
        } else {
            buf.append("(reserved)");
        }
        return buf.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getLength() {
        return this.length;
    }

    public float getDuration() {
        return this.duration;
    }
}

