/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.controller;
import org.grails.forge.cli.command.templates.controllerSpec;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.TemplateRenderer;
import picocli.CommandLine;

@CommandLine.Command(name="create-controller", description={"Creates a Grails Controller"})
public class CreateControllerCommand
extends CodeGenCommand {
    public static final String NAME = "create-controller";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="CONTROLLER-NAME", description={"The name of the controller to create"})
    String controllerName;

    @Inject
    public CreateControllerCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateControllerCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        Project project = this.getProject(this.controllerName);
        TemplateRenderer templateRenderer = this.getTemplateRenderer(project);
        RenderResult controllerRenderResult = templateRenderer.render(new RockerTemplate("grails-app/controllers/{packagePath}/{className}Controller.groovy", controller.template(project)), this.overwrite);
        RenderResult controllerSpecRenderResult = templateRenderer.render(new RockerTemplate("src/test/groovy/{packagePath}/{className}ControllerSpec.groovy", controllerSpec.template(project)), this.overwrite);
        if (controllerRenderResult != null && controllerSpecRenderResult != null) {
            this.logRenderResult(controllerRenderResult);
            this.logRenderResult(controllerSpecRenderResult);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered controller to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

