/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.hateoas.Resource;
import io.micronaut.jackson.modules.BeanIntrospectionModule;
import java.util.List;

@Internal
@Requires(missingBeans={BeanIntrospectionModule.class})
public class ResourceDeserializerModifier
extends BeanDeserializerModifier {
    @Override
    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        if (Resource.class.isAssignableFrom(beanDesc.getBeanClass())) {
            for (int i2 = 0; i2 < propDefs.size(); ++i2) {
                BeanPropertyDefinition definition = propDefs.get(i2);
                if (definition.getName().equals("embedded")) {
                    propDefs.set(i2, definition.withSimpleName("_embedded"));
                }
                if (!definition.getName().equals("links")) continue;
                propDefs.set(i2, definition.withSimpleName("_links"));
            }
            return propDefs;
        }
        return super.updateProperties(config, beanDesc, propDefs);
    }
}

