/*
 * Decompiled with CFR 0.152.
 */
package grails.spring;

import grails.spring.DynamicElementReader;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grails.spring.BeanConfiguration;
import org.grails.spring.DefaultBeanConfiguration;
import org.grails.spring.DefaultRuntimeSpringConfiguration;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.NullSourceExtractor;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class BeanBuilder
extends GroovyObjectSupport {
    private static final Log LOG = LogFactory.getLog(BeanBuilder.class);
    private static final String CREATE_APPCTX = "createApplicationContext";
    private static final String REGISTER_BEANS = "registerBeans";
    private static final String BEANS = "beans";
    private static final String REF = "ref";
    private RuntimeSpringConfiguration springConfig;
    private BeanConfiguration currentBeanConfig;
    private Map<String, DeferredProperty> deferredProperties = new HashMap<String, DeferredProperty>();
    private ApplicationContext parentCtx;
    private Map<String, Object> binding = Collections.emptyMap();
    private ClassLoader classLoader = null;
    private NamespaceHandlerResolver namespaceHandlerResolver;
    private Map<String, NamespaceHandler> namespaceHandlers = new HashMap<String, NamespaceHandler>();
    private XmlBeanDefinitionReader xmlBeanDefinitionReader;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Resource beanBuildResource = new ByteArrayResource(new byte[0]);
    private XmlReaderContext readerContext;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public BeanBuilder() {
        this(null, null);
    }

    public BeanBuilder(ClassLoader classLoader) {
        this(null, classLoader);
    }

    public BeanBuilder(ApplicationContext parent) {
        this(parent, null);
    }

    public BeanBuilder(ApplicationContext parent, ClassLoader classLoader) {
        this(parent, null, classLoader);
    }

    public BeanBuilder(ApplicationContext parentCtx, RuntimeSpringConfiguration springConfig, ClassLoader classLoader) {
        this.springConfig = springConfig == null ? this.createRuntimeSpringConfiguration(parentCtx, classLoader) : springConfig;
        this.parentCtx = parentCtx;
        this.classLoader = classLoader;
        this.initializeSpringConfig();
    }

    public void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        Assert.notNull((Object)resourcePatternResolver, "The argument [resourcePatternResolver] cannot be null");
        this.resourcePatternResolver = resourcePatternResolver;
    }

    protected void initializeSpringConfig() {
        this.xmlBeanDefinitionReader = new XmlBeanDefinitionReader((GenericApplicationContext)this.springConfig.getUnrefreshedApplicationContext());
        this.initializeBeanBuilderForClassLoader(this.classLoader);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.initializeBeanBuilderForClassLoader(classLoader);
    }

    protected void initializeBeanBuilderForClassLoader(ClassLoader classLoader) {
        this.xmlBeanDefinitionReader.setBeanClassLoader(classLoader);
        this.namespaceHandlerResolver = new DefaultNamespaceHandlerResolver(this.classLoader);
        this.readerContext = new XmlReaderContext(this.beanBuildResource, new FailFastProblemReporter(), new EmptyReaderEventListener(), new NullSourceExtractor(), this.xmlBeanDefinitionReader, this.namespaceHandlerResolver);
    }

    public void setNamespaceHandlerResolver(NamespaceHandlerResolver namespaceHandlerResolver) {
        this.namespaceHandlerResolver = namespaceHandlerResolver;
    }

    protected RuntimeSpringConfiguration createRuntimeSpringConfiguration(ApplicationContext parent, ClassLoader cl) {
        return new DefaultRuntimeSpringConfiguration(parent, cl);
    }

    public Log getLog() {
        return LOG;
    }

    public void importBeans(String resourcePattern) {
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(resourcePattern)) {
                this.importBeans(resource);
            }
        }
        catch (IOException e) {
            LOG.error("Error loading beans for resource pattern: " + resourcePattern, e);
        }
    }

    public void importBeans(Resource resource) {
        if (resource.getFilename().endsWith(".groovy")) {
            this.loadBeans(resource);
        } else if (resource.getFilename().endsWith(".xml")) {
            String[] beanNames;
            SimpleBeanDefinitionRegistry beanRegistry = new SimpleBeanDefinitionRegistry();
            XmlBeanDefinitionReader beanReader = new XmlBeanDefinitionReader(beanRegistry);
            beanReader.loadBeanDefinitions(resource);
            for (String beanName : beanNames = beanRegistry.getBeanDefinitionNames()) {
                this.springConfig.addBeanDefinition(beanName, beanRegistry.getBeanDefinition(beanName));
            }
        }
    }

    public void xmlns(Map<String, String> definition) {
        Assert.notNull((Object)this.namespaceHandlerResolver, "You cannot define a Spring namespace without a [namespaceHandlerResolver] set");
        if (definition.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : definition.entrySet()) {
            String namespace = entry.getKey();
            String uri = entry.getValue() == null ? null : entry.getValue();
            Assert.notNull((Object)uri, "Namespace definition cannot supply a null URI");
            NamespaceHandler namespaceHandler = this.namespaceHandlerResolver.resolve(uri);
            if (namespaceHandler == null) {
                throw new BeanDefinitionParsingException(new Problem("No namespace handler found for URI: " + uri, new Location(this.readerContext.getResource())));
            }
            this.namespaceHandlers.put(namespace, namespaceHandler);
            this.namespaces.put(namespace, uri);
        }
    }

    public ApplicationContext getParentCtx() {
        return this.parentCtx;
    }

    public RuntimeSpringConfiguration getSpringConfig() {
        return this.springConfig;
    }

    public BeanDefinition getBeanDefinition(String name) {
        if (!this.getSpringConfig().containsBean(name)) {
            return null;
        }
        return this.getSpringConfig().getBeanConfig(name).getBeanDefinition();
    }

    public Map<String, BeanDefinition> getBeanDefinitions() {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String beanName : this.getSpringConfig().getBeanNames()) {
            beanDefinitions.put(beanName, this.getSpringConfig().getBeanConfig(beanName).getBeanDefinition());
        }
        return beanDefinitions;
    }

    public void setSpringConfig(RuntimeSpringConfiguration springConfig) {
        this.springConfig = springConfig;
        this.initializeSpringConfig();
    }

    public void loadBeans(String resourcePattern) throws IOException {
        this.loadBeans(new PathMatchingResourcePatternResolver().getResources(resourcePattern));
    }

    public void loadBeans(Resource resource) {
        this.beanBuildResource = resource;
        this.loadBeans(new Resource[]{resource});
    }

    public void loadBeans(Resource[] resources) {
        Closure beans2 = new Closure((Object)this){
            private static final long serialVersionUID = -2778328821635253740L;

            public Object call(Object ... args) {
                BeanBuilder.this.invokeBeanDefiningClosure((Closure)args[0]);
                return null;
            }
        };
        Binding b = new Binding(){

            @Override
            public void setVariable(String name, Object value) {
                if (BeanBuilder.this.currentBeanConfig == null) {
                    super.setVariable(name, value);
                } else {
                    BeanBuilder.this.setPropertyOnBeanConfig(name, value);
                }
            }
        };
        b.setVariable(BEANS, beans2);
        for (Resource resource : resources) {
            try {
                GroovyShell shell = this.classLoader == null ? new GroovyShell(b) : new GroovyShell(this.classLoader, b);
                shell.evaluate(new InputStreamReader(resource.getInputStream(), "UTF-8"));
            }
            catch (Throwable e) {
                throw new BeanDefinitionParsingException(new Problem("Error evaluating bean definition script: " + e.getMessage(), new Location(resource), null, e));
            }
        }
    }

    public void registerBeans(BeanDefinitionRegistry registry) {
        this.finalizeDeferredProperties();
        if (registry instanceof GenericApplicationContext) {
            GenericApplicationContext ctx = (GenericApplicationContext)registry;
            ctx.setClassLoader(this.classLoader);
            ctx.getBeanFactory().setBeanClassLoader(this.classLoader);
        }
        this.springConfig.registerBeansWithRegistry(registry);
    }

    public void registerBeans(RuntimeSpringConfiguration targetSpringConfig) {
        this.springConfig.registerBeansWithConfig(targetSpringConfig);
    }

    @Override
    public Object invokeMethod(String name, Object arg) {
        Object[] args = (Object[])arg;
        if (CREATE_APPCTX.equals(name)) {
            return this.createApplicationContext();
        }
        if (REGISTER_BEANS.equals(name) && args.length == 1 && args[0] instanceof GenericApplicationContext) {
            this.registerBeans((GenericApplicationContext)args[0]);
            return null;
        }
        if (BEANS.equals(name) && args.length == 1 && args[0] instanceof Closure) {
            return this.beans((Closure)args[0]);
        }
        if (REF.equals(name)) {
            Assert.notNull(args[0], "Argument to ref() is not a valid bean or was not found");
            String refName = args[0] instanceof RuntimeBeanReference ? ((RuntimeBeanReference)args[0]).getBeanName() : args[0].toString();
            boolean parentRef = false;
            if (args.length > 1 && args[1] instanceof Boolean) {
                parentRef = (Boolean)args[1];
            }
            return new RuntimeBeanReference(refName, parentRef);
        }
        if (this.namespaceHandlers.containsKey(name) && args.length > 0 && args[0] instanceof Closure) {
            this.createDynamicElementReader(name, true).invokeMethod("doCall", args);
            return this;
        }
        if (args.length > 0 && args[0] instanceof Closure) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        if (args.length > 0 && args[0] instanceof Class || args.length > 0 && args[0] instanceof RuntimeBeanReference || args.length > 0 && args[0] instanceof Map) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        if (args.length > 1 && args[args.length - 1] instanceof Closure) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        ApplicationContext ctx = this.springConfig.getUnrefreshedApplicationContext();
        MetaClass mc = DefaultGroovyMethods.getMetaClass(ctx);
        if (!mc.respondsTo(ctx, name, args).isEmpty()) {
            return mc.invokeMethod((Object)ctx, name, args);
        }
        return this;
    }

    public BeanBuilder beans(Closure<?> c) {
        return this.invokeBeanDefiningClosure(c);
    }

    public ApplicationContext createApplicationContext() {
        this.finalizeDeferredProperties();
        return this.springConfig.getApplicationContext();
    }

    protected void finalizeDeferredProperties() {
        for (DeferredProperty dp : this.deferredProperties.values()) {
            if (dp.value instanceof List) {
                dp.value = this.manageListIfNecessary(dp.value);
            } else if (dp.value instanceof Map) {
                dp.value = this.manageMapIfNecessary(dp.value);
            }
            dp.setInBeanConfig();
        }
        this.deferredProperties.clear();
    }

    protected boolean addToDeferred(BeanConfiguration beanConfig, String property, Object newValue) {
        if (newValue instanceof List) {
            this.deferredProperties.put(this.currentBeanConfig.getName() + property, new DeferredProperty(this.currentBeanConfig, property, newValue));
            return true;
        }
        if (newValue instanceof Map) {
            this.deferredProperties.put(this.currentBeanConfig.getName() + property, new DeferredProperty(this.currentBeanConfig, property, newValue));
            return true;
        }
        return false;
    }

    protected BeanConfiguration invokeBeanDefiningMethod(String name, Object[] args) {
        boolean hasClosureArgument = args[args.length - 1] instanceof Closure;
        if (args[0] instanceof Class) {
            Class<?> beanClass;
            Class<?> clazz = beanClass = args[0] instanceof Class ? (Class<?>)args[0] : args[0].getClass();
            if (args.length >= 1) {
                this.currentBeanConfig = hasClosureArgument ? (args.length - 1 != 1 ? this.springConfig.addSingletonBean(name, beanClass, this.resolveConstructorArguments(args, 1, args.length - 1)) : this.springConfig.addSingletonBean(name, beanClass)) : this.springConfig.addSingletonBean(name, beanClass, this.resolveConstructorArguments(args, 1, args.length));
            }
        } else if (args[0] instanceof RuntimeBeanReference) {
            this.currentBeanConfig = this.springConfig.addSingletonBean(name);
            this.currentBeanConfig.setFactoryBean(((RuntimeBeanReference)args[0]).getBeanName());
        } else if (args[0] instanceof Map) {
            if (args.length > 1 && args[1] instanceof Class) {
                constructorArgs = this.resolveConstructorArguments(args, 2, hasClosureArgument ? args.length - 1 : args.length);
                this.currentBeanConfig = this.springConfig.addSingletonBean(name, (Class)args[1], constructorArgs);
                Map namedArgs = (Map)args[0];
                for (Object o : namedArgs.keySet()) {
                    String propName = (String)o;
                    this.setProperty(propName, namedArgs.get(propName));
                }
            } else {
                int constructorArgsTest;
                Map.Entry factoryBeanEntry = ((Map)args[0]).entrySet().iterator().next();
                int n = constructorArgsTest = hasClosureArgument ? 2 : 1;
                if (args.length > constructorArgsTest) {
                    int endOfConstructArgs = hasClosureArgument ? args.length - 1 : args.length;
                    this.currentBeanConfig = this.springConfig.addSingletonBean(name, null, this.resolveConstructorArguments(args, 1, endOfConstructArgs));
                } else {
                    this.currentBeanConfig = this.springConfig.addSingletonBean(name);
                }
                this.currentBeanConfig.setFactoryBean(factoryBeanEntry.getKey().toString());
                this.currentBeanConfig.setFactoryMethod(factoryBeanEntry.getValue().toString());
            }
        } else if (args[0] instanceof Closure) {
            this.currentBeanConfig = this.springConfig.addAbstractBean(name);
        } else {
            constructorArgs = this.resolveConstructorArguments(args, 0, hasClosureArgument ? args.length - 1 : args.length);
            this.currentBeanConfig = new DefaultBeanConfiguration(name, null, constructorArgs);
            this.springConfig.addBeanConfiguration(name, this.currentBeanConfig);
        }
        if (hasClosureArgument) {
            Closure callable = (Closure)args[args.length - 1];
            callable.setDelegate(this);
            callable.setResolveStrategy(1);
            callable.call(new Object[]{this.currentBeanConfig});
        }
        BeanConfiguration beanConfig = this.currentBeanConfig;
        this.currentBeanConfig = null;
        return beanConfig;
    }

    protected List resolveConstructorArguments(Object[] args, int start, int end) {
        Object[] constructorArgs = this.subarray(args, start, end);
        this.filterGStringReferences(constructorArgs);
        for (int i2 = 0; i2 < constructorArgs.length; ++i2) {
            if (constructorArgs[i2] instanceof List) {
                constructorArgs[i2] = this.manageListIfNecessary(constructorArgs[i2]);
                continue;
            }
            if (!(constructorArgs[i2] instanceof Map)) continue;
            constructorArgs[i2] = this.manageMapIfNecessary(constructorArgs[i2]);
        }
        return Arrays.asList(constructorArgs);
    }

    protected Object[] subarray(Object[] args, int i2, int j) {
        Assert.isTrue(j <= args.length, "Upper bound can't be greater than array length");
        Object[] b = new Object[j - i2];
        int n = 0;
        int k = i2;
        while (k < j) {
            b[n] = args[k];
            ++k;
            ++n;
        }
        return b;
    }

    protected void filterGStringReferences(Object[] constructorArgs) {
        for (int i2 = 0; i2 < constructorArgs.length; ++i2) {
            Object constructorArg = constructorArgs[i2];
            if (!(constructorArg instanceof GString)) continue;
            constructorArgs[i2] = constructorArg.toString();
        }
    }

    protected BeanBuilder invokeBeanDefiningClosure(Closure<?> callable) {
        callable.setDelegate(this);
        callable.call();
        this.finalizeDeferredProperties();
        return this;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.currentBeanConfig != null) {
            this.setPropertyOnBeanConfig(name, value);
        }
    }

    public AbstractBeanDefinition bean(Class<?> type) {
        return this.springConfig.createSingletonBean(type).getBeanDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBeanDefinition bean(Class type, Object ... args) {
        BeanConfiguration current = this.currentBeanConfig;
        try {
            Closure callable = null;
            List constructorArgs = null;
            if (args != null && args.length > 0) {
                int index2 = args.length;
                Object lastArg = args[index2 - 1];
                if (lastArg instanceof Closure) {
                    callable = (Closure)lastArg;
                    --index2;
                }
                if (index2 > -1) {
                    constructorArgs = this.resolveConstructorArguments(args, 0, index2);
                }
            }
            BeanConfiguration beanConfiguration = this.currentBeanConfig = constructorArgs == null ? this.springConfig.createSingletonBean(type) : this.springConfig.createSingletonBean(type, constructorArgs);
            if (callable != null) {
                callable.call(new Object[]{this.currentBeanConfig});
            }
            AbstractBeanDefinition abstractBeanDefinition = this.currentBeanConfig.getBeanDefinition();
            return abstractBeanDefinition;
        }
        finally {
            this.currentBeanConfig = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyOnBeanConfig(String name, Object value) {
        if (value instanceof GString) {
            value = value.toString();
        }
        if (this.addToDeferred(this.currentBeanConfig, name, value)) {
            return;
        }
        if (value instanceof Closure) {
            BeanConfiguration current = this.currentBeanConfig;
            try {
                Closure callable = (Closure)value;
                Class<?> parameterType = callable.getParameterTypes()[0];
                if (parameterType.equals(Object.class)) {
                    this.currentBeanConfig = this.springConfig.createSingletonBean("");
                    callable.call(new Object[]{this.currentBeanConfig});
                } else {
                    this.currentBeanConfig = this.springConfig.createSingletonBean(parameterType);
                    callable.call();
                }
                value = this.currentBeanConfig.getBeanDefinition();
            }
            finally {
                this.currentBeanConfig = current;
            }
        }
        this.currentBeanConfig.addProperty(name, value);
    }

    protected Object manageMapIfNecessary(Object value) {
        Map map = (Map)value;
        boolean containsRuntimeRefs = false;
        for (Object e : map.values()) {
            if (!(e instanceof RuntimeBeanReference)) continue;
            containsRuntimeRefs = true;
            break;
        }
        if (containsRuntimeRefs) {
            ManagedMap managedMap = new ManagedMap();
            managedMap.putAll(map);
            return managedMap;
        }
        return value;
    }

    protected Object manageListIfNecessary(Object value) {
        List list = value;
        boolean containsRuntimeRefs = false;
        for (Object e : list) {
            if (!(e instanceof RuntimeBeanReference)) continue;
            containsRuntimeRefs = true;
            break;
        }
        if (containsRuntimeRefs) {
            ManagedList tmp = new ManagedList();
            tmp.addAll(value);
            value = tmp;
        }
        return value;
    }

    @Override
    public Object getProperty(String name) {
        if (this.binding.containsKey(name)) {
            return this.binding.get(name);
        }
        if (this.namespaceHandlers.containsKey(name)) {
            return this.createDynamicElementReader(name, this.currentBeanConfig != null);
        }
        if (this.springConfig.containsBean(name)) {
            BeanConfiguration beanConfig = this.springConfig.getBeanConfig(name);
            if (beanConfig != null) {
                return new ConfigurableRuntimeBeanReference(name, this.springConfig.getBeanConfig(name), false);
            }
            return new RuntimeBeanReference(name, false);
        }
        if (this.currentBeanConfig != null) {
            if (this.currentBeanConfig.hasProperty(name)) {
                return this.currentBeanConfig.getPropertyValue(name);
            }
            DeferredProperty dp = this.deferredProperties.get(this.currentBeanConfig.getName() + name);
            if (dp != null) {
                return dp.value;
            }
            return super.getProperty(name);
        }
        return super.getProperty(name);
    }

    protected DynamicElementReader createDynamicElementReader(String namespace, final boolean decorator) {
        NamespaceHandler handler = this.namespaceHandlers.get(namespace);
        ParserContext parserContext = new ParserContext(this.readerContext, new BeanDefinitionParserDelegate(this.readerContext));
        DynamicElementReader dynamicElementReader = new DynamicElementReader(namespace, this.namespaces, handler, parserContext){

            @Override
            protected void afterInvocation() {
                if (!decorator) {
                    BeanBuilder.this.currentBeanConfig = null;
                }
            }
        };
        dynamicElementReader.setClassLoader(this.classLoader);
        if (this.currentBeanConfig != null) {
            dynamicElementReader.setBeanConfiguration(this.currentBeanConfig);
        } else if (!decorator) {
            this.currentBeanConfig = new DefaultBeanConfiguration(namespace);
            dynamicElementReader.setBeanConfiguration(this.currentBeanConfig);
        }
        dynamicElementReader.setBeanDecorator(decorator);
        return dynamicElementReader;
    }

    public void setBinding(Binding b) {
        this.binding = b.getVariables();
    }

    private class DeferredProperty {
        private BeanConfiguration config;
        private String name;
        private Object value;

        DeferredProperty(BeanConfiguration config, String name, Object value) {
            this.config = config;
            this.name = name;
            this.value = value;
        }

        public void setInBeanConfig() {
            this.config.addProperty(this.name, this.value);
        }
    }

    private class ConfigurableRuntimeBeanReference
    extends RuntimeBeanReference
    implements GroovyObject {
        private MetaClass metaClass;
        private BeanConfiguration beanConfig;

        public ConfigurableRuntimeBeanReference(String beanName, BeanConfiguration beanConfig, boolean toParent) {
            super(beanName, toParent);
            Assert.notNull((Object)beanConfig, "Argument [beanConfig] cannot be null");
            this.beanConfig = beanConfig;
            this.metaClass = InvokerHelper.getMetaClass(this);
        }

        @Override
        public MetaClass getMetaClass() {
            return this.metaClass;
        }

        @Override
        public Object getProperty(String property) {
            if (property.equals("beanName")) {
                return this.getBeanName();
            }
            if (property.equals("source")) {
                return this.getSource();
            }
            if (this.beanConfig != null) {
                return new WrappedPropertyValue(property, this.beanConfig.getPropertyValue(property));
            }
            return this.metaClass.getProperty(this, property);
        }

        @Override
        public Object invokeMethod(String name, Object args) {
            return this.metaClass.invokeMethod((Object)this, name, args);
        }

        @Override
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        public void setProperty(String property, Object newValue) {
            if (!BeanBuilder.this.addToDeferred(this.beanConfig, property, newValue)) {
                this.beanConfig.setPropertyValue(property, newValue);
            }
        }

        private class WrappedPropertyValue
        extends GroovyObjectSupport {
            private Object propertyValue;
            private String propertyName;

            public WrappedPropertyValue(String propertyName, Object propertyValue) {
                this.propertyValue = propertyValue;
                this.propertyName = propertyName;
            }

            public void leftShift(Object value) {
                InvokerHelper.invokeMethod(this.propertyValue, "leftShift", value);
                this.updateDeferredProperties(value);
            }

            public boolean add(Object value) {
                boolean retval = (Boolean)InvokerHelper.invokeMethod(this.propertyValue, "add", value);
                this.updateDeferredProperties(value);
                return retval;
            }

            public boolean addAll(Collection values) {
                boolean retval = (Boolean)InvokerHelper.invokeMethod(this.propertyValue, "addAll", values);
                for (Object value : values) {
                    this.updateDeferredProperties(value);
                }
                return retval;
            }

            @Override
            public Object invokeMethod(String name, Object args) {
                return InvokerHelper.invokeMethod(this.propertyValue, name, args);
            }

            @Override
            public Object getProperty(String name) {
                return InvokerHelper.getProperty(this.propertyValue, name);
            }

            @Override
            public void setProperty(String name, Object value) {
                InvokerHelper.setProperty(this.propertyValue, name, value);
            }

            private void updateDeferredProperties(Object value) {
                if (value instanceof RuntimeBeanReference) {
                    BeanBuilder.this.deferredProperties.put(ConfigurableRuntimeBeanReference.this.beanConfig.getName(), new DeferredProperty(ConfigurableRuntimeBeanReference.this.beanConfig, this.propertyName, this.propertyValue));
                }
            }
        }
    }
}

