/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

class BufferedXORIterator
implements CloneableIterator<EWAHIterator> {
    EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    long[] hardbitmap;
    LinkedList<IteratingRLW> ll;

    BufferedXORIterator(LinkedList<IteratingRLW> basell, int bufSize) {
        this.ll = basell;
        this.hardbitmap = new long[bufSize];
    }

    public BufferedXORIterator clone() throws CloneNotSupportedException {
        BufferedXORIterator answer = (BufferedXORIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (long[])this.hardbitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        long effective = 0L;
        Iterator i2 = this.ll.iterator();
        while (i2.hasNext()) {
            IteratingRLW rlw = (IteratingRLW)i2.next();
            if (rlw.size() > 0L) {
                int eff = IteratorAggregation.inplacexor(this.hardbitmap, rlw);
                if ((long)eff <= effective) continue;
                effective = eff;
                continue;
            }
            i2.remove();
        }
        int k = 0;
        while ((long)k < effective) {
            this.buffer.addWord(this.hardbitmap[k]);
            ++k;
        }
        Arrays.fill(this.hardbitmap, 0L);
        return this.buffer.getEWAHIterator();
    }
}

