/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.streaming.util.serialization;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.table.store.shaded.streaming.connectors.kafka.KafkaDeserializationSchema;

@PublicEvolving
public class JSONKeyValueDeserializationSchema
implements KafkaDeserializationSchema<ObjectNode> {
    private static final long serialVersionUID = 1509391548173891955L;
    private final boolean includeMetadata;
    private ObjectMapper mapper;

    public JSONKeyValueDeserializationSchema(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    @Override
    public ObjectNode deserialize(ConsumerRecord<byte[], byte[]> record) throws Exception {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        ObjectNode node = this.mapper.createObjectNode();
        if (record.key() != null) {
            node.set("key", (JsonNode)this.mapper.readValue(record.key(), JsonNode.class));
        }
        if (record.value() != null) {
            node.set("value", (JsonNode)this.mapper.readValue(record.value(), JsonNode.class));
        }
        if (this.includeMetadata) {
            node.putObject("metadata").put("offset", record.offset()).put("topic", record.topic()).put("partition", record.partition());
        }
        return node;
    }

    @Override
    public boolean isEndOfStream(ObjectNode nextElement) {
        return false;
    }

    public TypeInformation<ObjectNode> getProducedType() {
        return TypeExtractor.getForClass(ObjectNode.class);
    }
}

