/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.requests;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchMetadata {
    public static final Logger log = LoggerFactory.getLogger(FetchMetadata.class);
    public static final int INVALID_SESSION_ID = 0;
    public static final int INITIAL_EPOCH = 0;
    public static final int FINAL_EPOCH = -1;
    public static final FetchMetadata INITIAL = new FetchMetadata(0, 0);
    public static final FetchMetadata LEGACY = new FetchMetadata(0, -1);
    private final int sessionId;
    private final int epoch;

    public static int nextEpoch(int prevEpoch) {
        if (prevEpoch < 0) {
            return -1;
        }
        if (prevEpoch == Integer.MAX_VALUE) {
            return 1;
        }
        return prevEpoch + 1;
    }

    public FetchMetadata(int sessionId, int epoch) {
        this.sessionId = sessionId;
        this.epoch = epoch;
    }

    public boolean isFull() {
        return this.epoch == 0 || this.epoch == -1;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int epoch() {
        return this.epoch;
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.epoch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchMetadata that = (FetchMetadata)o;
        return this.sessionId == that.sessionId && this.epoch == that.epoch;
    }

    public FetchMetadata nextCloseExisting() {
        return new FetchMetadata(this.sessionId, 0);
    }

    public static FetchMetadata newIncremental(int sessionId) {
        return new FetchMetadata(sessionId, FetchMetadata.nextEpoch(0));
    }

    public FetchMetadata nextIncremental() {
        return new FetchMetadata(this.sessionId, FetchMetadata.nextEpoch(this.epoch));
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        if (this.sessionId == 0) {
            bld.append("(sessionId=INVALID, ");
        } else {
            bld.append("(sessionId=").append(this.sessionId).append(", ");
        }
        if (this.epoch == 0) {
            bld.append("epoch=INITIAL)");
        } else if (this.epoch == -1) {
            bld.append("epoch=FINAL)");
        } else {
            bld.append("epoch=").append(this.epoch).append(")");
        }
        return bld.toString();
    }
}

