/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.parquet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.utils.ReflectionUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class ParquetInputFormatFactory {
    public static BulkFormat<RowData, FileSourceSplit> create(Configuration conf, RowType producedRowType, TypeInformation<RowData> producedTypeInfo, boolean isUtcTimestamp) {
        try {
            Class<?> formatClass = Class.forName("org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.ParquetColumnarRowInputFormat");
            Method method = Arrays.stream(formatClass.getDeclaredMethods()).filter(m -> "createPartitionedFormat".equals(m.getName())).findAny().orElseThrow(NoSuchMethodException::new);
            int paramCnt = method.getParameterCount();
            return paramCnt == 8 ? ParquetInputFormatFactory.createFrom115(method, conf, producedRowType, producedTypeInfo, isUtcTimestamp) : ParquetInputFormatFactory.createFrom114(method, conf, producedRowType, isUtcTimestamp);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static BulkFormat<RowData, FileSourceSplit> createFrom115(Method method, Configuration conf, RowType producedRowType, TypeInformation<RowData> producedTypeInfo, boolean isUtcTimestamp) throws NoSuchMethodException {
        try {
            return (BulkFormat)ReflectionUtils.invokeStaticMethod(method, conf, producedRowType, producedTypeInfo, Collections.emptyList(), null, 2048, isUtcTimestamp, true);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static BulkFormat<RowData, FileSourceSplit> createFrom114(Method method, Configuration conf, RowType producedRowType, boolean isUtcTimestamp) throws NoSuchMethodException {
        try {
            return (BulkFormat)ReflectionUtils.invokeStaticMethod(method, conf, producedRowType, Collections.emptyList(), null, 2048, isUtcTimestamp, true);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

