/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.event.EventUtil;
import org.apache.felix.ipojo.handlers.event.subscriber.EventAdminSubscriberHandlerDescription;
import org.apache.felix.ipojo.handlers.event.subscriber.EventAdminSubscriberMetadata;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Callback;
import org.osgi.framework.Filter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventAdminSubscriberHandler
extends PrimitiveHandler
implements EventHandler,
Pojo {
    private InstanceManager __IM;
    public static final String NAMESPACE = "org.apache.felix.ipojo.handlers.event";
    public static final String TOPICS_PROPERTY = "event.topics";
    public static final String FILTER_PROPERTY = "event.filter";
    private static final String LOG_PREFIX = "EVENT ADMIN SUBSCRIBER HANDLER : ";
    private boolean __Fm_manager;
    private InstanceManager m_manager;
    private boolean __Fm_subscribersByName;
    private final Map m_subscribersByName;
    private boolean __Fm_callbacksByName;
    private final Map m_callbacksByName;
    private boolean __Fm_topics;
    private String[] m_topics;
    private boolean __Fm_isListening;
    private boolean m_isListening;
    private boolean __Fm_description;
    private EventAdminSubscriberHandlerDescription m_description;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$org$osgi$service$event$Event;
    private boolean __MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetDescription;
    private boolean __MhandleEvent$org_osgi_service_event_Event;
    private boolean __MgetCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata;

    InstanceManager __getm_manager() {
        if (!this.__Fm_manager) {
            return this.m_manager;
        }
        return (InstanceManager)this.__IM.onGet((Object)this, "m_manager");
    }

    void __setm_manager(InstanceManager instanceManager) {
        if (!this.__Fm_manager) {
            this.m_manager = instanceManager;
            return;
        }
        this.__IM.onSet((Object)this, "m_manager", (Object)instanceManager);
    }

    Map __getm_subscribersByName() {
        if (!this.__Fm_subscribersByName) {
            return this.m_subscribersByName;
        }
        return (Map)this.__IM.onGet((Object)this, "m_subscribersByName");
    }

    void __setm_subscribersByName(Map map) {
        if (!this.__Fm_subscribersByName) {
            this.m_subscribersByName = map;
            return;
        }
        this.__IM.onSet((Object)this, "m_subscribersByName", (Object)map);
    }

    Map __getm_callbacksByName() {
        if (!this.__Fm_callbacksByName) {
            return this.m_callbacksByName;
        }
        return (Map)this.__IM.onGet((Object)this, "m_callbacksByName");
    }

    void __setm_callbacksByName(Map map) {
        if (!this.__Fm_callbacksByName) {
            this.m_callbacksByName = map;
            return;
        }
        this.__IM.onSet((Object)this, "m_callbacksByName", (Object)map);
    }

    String[] __getm_topics() {
        if (!this.__Fm_topics) {
            return this.m_topics;
        }
        return (String[])this.__IM.onGet((Object)this, "m_topics");
    }

    void __setm_topics(String[] stringArray) {
        if (!this.__Fm_topics) {
            this.m_topics = stringArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_topics", (Object)stringArray);
    }

    boolean __getm_isListening() {
        if (!this.__Fm_isListening) {
            return this.m_isListening;
        }
        Object object = this.__IM.onGet((Object)this, "m_isListening");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_isListening(boolean bl) {
        if (!this.__Fm_isListening) {
            this.m_isListening = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_isListening", (Object)bl2);
    }

    EventAdminSubscriberHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (EventAdminSubscriberHandlerDescription)((Object)this.__IM.onGet((Object)this, "m_description"));
    }

    void __setm_description(EventAdminSubscriberHandlerDescription eventAdminSubscriberHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = eventAdminSubscriberHandlerDescription;
            return;
        }
        this.__IM.onSet((Object)this, "m_description", (Object)eventAdminSubscriberHandlerDescription);
    }

    public EventAdminSubscriberHandler() {
        this(null);
    }

    private EventAdminSubscriberHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_subscribersByName(new HashMap());
        this.__setm_callbacksByName(new Hashtable());
    }

    public void initializeComponentFactory(ComponentTypeDescription componentTypeDescription, Element element) throws ConfigurationException {
        if (!this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element) {
            this.__initializeComponentFactory(componentTypeDescription, element);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", new Object[]{componentTypeDescription, element});
            this.__initializeComponentFactory(componentTypeDescription, element);
            this.__IM.onExit((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __initializeComponentFactory(ComponentTypeDescription cd, Element metadata) throws ConfigurationException {
        Properties dict = new Properties();
        cd.addProperty(new PropertyDescription(TOPICS_PROPERTY, (class$java$util$Dictionary == null ? (class$java$util$Dictionary = EventAdminSubscriberHandler.class$("java.util.Dictionary")) : class$java$util$Dictionary).getName(), ((Object)dict).toString()));
        dict = new Properties();
        cd.addProperty(new PropertyDescription(FILTER_PROPERTY, (class$java$util$Dictionary == null ? (class$java$util$Dictionary = EventAdminSubscriberHandler.class$("java.util.Dictionary")) : class$java$util$Dictionary).getName(), ((Object)dict).toString()));
        Element[] subscribers = metadata.getElements("subscriber", NAMESPACE);
        if (subscribers != null) {
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> callbackSet = new HashSet<String>();
            for (int i = 0; i < subscribers.length; ++i) {
                EventAdminSubscriberMetadata subscriberMetadata = new EventAdminSubscriberMetadata(this.getFactory().getBundleContext(), subscribers[i]);
                String name = subscriberMetadata.getName();
                this.info("EVENT ADMIN SUBSCRIBER HANDLER : Checking subscriber " + name);
                PojoMetadata pojoMetadata = this.getPojoMetadata();
                String callbackType = subscriberMetadata.getDataKey() == null ? (class$org$osgi$service$event$Event == null ? EventAdminSubscriberHandler.class$("org.osgi.service.event.Event") : class$org$osgi$service$event$Event).getName() : subscriberMetadata.getDataType().getName();
                MethodMetadata methodMetadata = pojoMetadata.getMethod(subscriberMetadata.getCallback(), new String[]{callbackType});
                String callbackSignature = subscriberMetadata.getCallback() + "(" + callbackType + ")";
                if (methodMetadata == null) {
                    throw new ConfigurationException("Cannot find callback method " + callbackSignature);
                }
                if (callbackSet.contains(callbackSignature)) {
                    this.warn("The callback method is already used by another subscriber : " + callbackSignature);
                } else {
                    callbackSet.add(callbackSignature);
                }
                if (nameSet.contains(name)) {
                    throw new ConfigurationException("A subscriber with the same name already exists : " + name);
                }
                nameSet.add(name);
            }
            this.__setm_description(new EventAdminSubscriberHandlerDescription((Handler)this, subscribers));
        } else {
            this.info("EVENT ADMIN SUBSCRIBER HANDLER : No subscriber to check");
        }
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __configure(Element metadata, Dictionary conf) throws ConfigurationException {
        this.__setm_manager(this.getInstanceManager());
        Dictionary instanceTopics = (Dictionary)conf.get(TOPICS_PROPERTY);
        Dictionary instanceFilter = (Dictionary)conf.get(FILTER_PROPERTY);
        Element[] subscribers = metadata.getElements("subscriber", NAMESPACE);
        TreeSet<String> topics = new TreeSet<String>();
        if (subscribers != null) {
            int i;
            for (i = 0; i < subscribers.length; ++i) {
                String filterString;
                String topicsString;
                EventAdminSubscriberMetadata subscriberMetadata = new EventAdminSubscriberMetadata(this.__getm_manager().getContext(), subscribers[i]);
                String name = subscriberMetadata.getName();
                this.info("EVENT ADMIN SUBSCRIBER HANDLER : Configuring subscriber " + name);
                String string = topicsString = instanceTopics != null ? (String)instanceTopics.get(name) : null;
                if (topicsString != null) {
                    subscriberMetadata.setTopics(topicsString);
                }
                String string2 = filterString = instanceFilter != null ? (String)instanceFilter.get(name) : null;
                if (filterString != null) {
                    subscriberMetadata.setFilter(filterString);
                }
                subscriberMetadata.check();
                String[] subscriberTopics = subscriberMetadata.getTopics();
                for (int j = 0; j < subscriberTopics.length; ++j) {
                    topics.add(subscriberTopics[j]);
                }
                PojoMetadata pojoMetadata = this.getPojoMetadata();
                String callbackType = subscriberMetadata.getDataKey() == null ? (class$org$osgi$service$event$Event == null ? EventAdminSubscriberHandler.class$("org.osgi.service.event.Event") : class$org$osgi$service$event$Event).getName() : subscriberMetadata.getDataType().getName();
                MethodMetadata methodMetadata = pojoMetadata.getMethod(subscriberMetadata.getCallback(), new String[]{callbackType});
                Callback callback = new Callback(methodMetadata, this.__getm_manager());
                this.__getm_callbacksByName().put(name, callback);
                this.__getm_subscribersByName().put(name, subscriberMetadata);
            }
            this.__setm_topics(new String[topics.size()]);
            i = 0;
            Iterator iterator = topics.iterator();
            while (iterator.hasNext()) {
                String tmp = (String)iterator.next();
                this.__getm_topics()[i++] = tmp;
            }
        } else {
            this.info("EVENT ADMIN SUBSCRIBER HANDLER : No subscriber to configure");
        }
    }

    public synchronized void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        this.__setm_isListening(true);
    }

    public synchronized void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        this.__setm_isListening(false);
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__getDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getDescription", new Object[0]);
            handlerDescription = this.__getDescription();
            this.__IM.onExit((Object)this, "getDescription", (Object)handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __getDescription() {
        return this.__getm_description();
    }

    public void handleEvent(Event event) {
        if (!this.__MhandleEvent$org_osgi_service_event_Event) {
            this.__handleEvent(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handleEvent$org_osgi_service_event_Event", new Object[]{event});
            this.__handleEvent(event);
            this.__IM.onExit((Object)this, "handleEvent$org_osgi_service_event_Event", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handleEvent$org_osgi_service_event_Event", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __handleEvent(Event event) {
        EventAdminSubscriberMetadata subscriberMetadata = null;
        String topic = event.getTopic();
        Collection subscribers = this.__getm_subscribersByName().values();
        Iterator i = subscribers.iterator();
        while (i.hasNext()) {
            subscriberMetadata = (EventAdminSubscriberMetadata)i.next();
            boolean isListening = false;
            Object callbackParam = null;
            Callback callback = null;
            EventAdminSubscriberHandler eventAdminSubscriberHandler = this;
            synchronized (eventAdminSubscriberHandler) {
                isListening = this.__getm_isListening();
            }
            Filter filter = subscriberMetadata.getFilter();
            if (EventUtil.matches(topic, subscriberMetadata.getTopics()) && (filter == null || event.matches(filter))) {
                String name = subscriberMetadata.getName();
                callback = (Callback)this.__getm_callbacksByName().get(name);
                try {
                    callbackParam = this.getCallbackParameter(event, subscriberMetadata);
                }
                catch (ClassCastException e) {
                    this.warn("EVENT ADMIN SUBSCRIBER HANDLER : Ignoring data event : Bad data type", e);
                }
                catch (NoSuchFieldException e) {
                    this.warn("EVENT ADMIN SUBSCRIBER HANDLER : Ignoring data event : No data", e);
                }
            }
            if (!isListening || callback == null || callbackParam == null) continue;
            try {
                callback.call(new Object[]{callbackParam});
            }
            catch (InvocationTargetException e) {
                this.error("EVENT ADMIN SUBSCRIBER HANDLER : The callback has thrown an exception", e.getTargetException());
            }
            catch (Exception e) {
                this.error("EVENT ADMIN SUBSCRIBER HANDLER : Unexpected exception when calling callback", e);
            }
        }
    }

    private Object getCallbackParameter(Event event, EventAdminSubscriberMetadata eventAdminSubscriberMetadata) throws ClassCastException, NoSuchFieldException {
        Object object;
        if (!this.__MgetCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata) {
            return this.__getCallbackParameter(event, eventAdminSubscriberMetadata);
        }
        try {
            this.__IM.onEntry((Object)this, "getCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata", new Object[]{event, eventAdminSubscriberMetadata});
            object = this.__getCallbackParameter(event, eventAdminSubscriberMetadata);
            this.__IM.onExit((Object)this, "getCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __getCallbackParameter(Event event, EventAdminSubscriberMetadata subscriberMetadata) throws ClassCastException, NoSuchFieldException {
        String dataKey = subscriberMetadata.getDataKey();
        if (dataKey == null) {
            return event;
        }
        boolean dataKeyPresent = false;
        String[] properties = event.getPropertyNames();
        for (int j = 0; j < properties.length && !dataKeyPresent; ++j) {
            if (!dataKey.equals(properties[j])) continue;
            dataKeyPresent = true;
        }
        if (dataKeyPresent) {
            Class<?> dataClazz;
            Object data = event.getProperty(dataKey);
            Class dataType = subscriberMetadata.getDataType();
            if (dataType.isAssignableFrom(dataClazz = data.getClass())) {
                return data;
            }
            throw new ClassCastException("Cannot convert " + dataClazz.getName() + " to " + dataType.getName());
        }
        throw new NoSuchFieldException(dataKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_subscribersByName")) {
                this.__Fm_subscribersByName = true;
            }
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_isListening")) {
                this.__Fm_isListening = true;
            }
            if (set.contains("m_callbacksByName")) {
                this.__Fm_callbacksByName = true;
            }
            if (set.contains("m_topics")) {
                this.__Fm_topics = true;
            }
            if (set.contains("m_manager")) {
                this.__Fm_manager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element")) {
                this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("handleEvent$org_osgi_service_event_Event")) {
                this.__MhandleEvent$org_osgi_service_event_Event = true;
            }
            if (set.contains("getCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata")) {
                this.__MgetCallbackParameter$org_osgi_service_event_Event$org_apache_felix_ipojo_handlers_event_subscriber_EventAdminSubscriberMetadata = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

