/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReaderToUTF8StreamTest
extends BaseTestCase {
    private static int DEFAULT_INTERNAL_BUFFER_SIZE = 32768;

    public ReaderToUTF8StreamTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new BaseTestSuite(ReaderToUTF8StreamTest.class);
    }

    public void testMarkResetSimplePosZero() throws IOException {
        InputStream inputStream = this.getStream(100);
        inputStream.mark(10);
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)inputStream.read(new byte[10]));
        inputStream.reset();
        this.checkBeginningOfStream(inputStream);
    }

    public void testMarkResetSimplePosNonZero() throws IOException {
        InputStream inputStream = this.getStream(200);
        ReaderToUTF8StreamTest.assertEquals((int)127, (int)inputStream.read(new byte[127]));
        inputStream.mark(10);
        byte[] byArray = new byte[10];
        byte[] byArray2 = new byte[10];
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)inputStream.read(byArray));
        inputStream.reset();
        ReaderToUTF8StreamTest.assertEquals((int)10, (int)inputStream.read(byArray2));
        ReaderToUTF8StreamTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public void testMarkResetShiftBytesFew_Internal() throws IOException {
        InputStream inputStream = this.getStream(131072);
        byte[] byArray = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 2048];
        this.fillArray(inputStream, byArray);
        inputStream.mark(4096);
        byte[] byArray2 = new byte[3072];
        byte[] byArray3 = new byte[3072];
        this.fillArray(inputStream, byArray2);
        InputStream inputStream2 = this.getStream(131072);
        InputStreamUtil.skipFully((InputStream)inputStream2, (long)(DEFAULT_INTERNAL_BUFFER_SIZE - 2048));
        byte[] byArray4 = new byte[3072];
        this.fillArray(inputStream2, byArray4);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(byArray4), new ByteArrayInputStream(byArray2));
        inputStream.reset();
        this.fillArray(inputStream, byArray3);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(byArray2), new ByteArrayInputStream(byArray3));
    }

    public void testMarkResetShiftBytesMany_Internal() throws IOException {
        InputStream inputStream = this.getStream(131072);
        inputStream.read();
        inputStream.read();
        inputStream.mark(DEFAULT_INTERNAL_BUFFER_SIZE - 6);
        byte[] byArray = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        byte[] byArray2 = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        this.fillArray(inputStream, byArray);
        InputStream inputStream2 = this.getStream(131072);
        inputStream2.read();
        inputStream2.read();
        byte[] byArray3 = new byte[DEFAULT_INTERNAL_BUFFER_SIZE - 6];
        this.fillArray(inputStream2, byArray3);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(byArray3), new ByteArrayInputStream(byArray));
        inputStream.reset();
        this.fillArray(inputStream, byArray2);
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(byArray), new ByteArrayInputStream(byArray2));
    }

    public void testMarkResetExceedReadAheadLimitOK_Internal() throws IOException {
        InputStream inputStream = this.getStream(4113);
        inputStream.mark(10);
        ReaderToUTF8StreamTest.assertEquals((int)20, (int)inputStream.read(new byte[20]));
        inputStream.reset();
    }

    public void testMarkResetExceedReadAheadLimitFail_Internal() throws IOException {
        InputStream inputStream = this.getStream(65553);
        inputStream.mark(10);
        int n = 38919;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
        }
        try {
            inputStream.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkResetOverflowInternalBufferKeepBytes() throws IOException {
        InputStream inputStream = this.getStream(131072);
        inputStream.mark(122880);
        byte[] byArray = new byte[122879];
        this.fillArray(inputStream, byArray);
        inputStream.reset();
        this.checkBeginningOfStream(inputStream);
        inputStream = this.getStream(36864);
        inputStream.mark(4096);
        byArray = new byte[36863];
        this.fillArray(inputStream, byArray);
        try {
            inputStream.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkReadUntilEOF() throws IOException {
        int n;
        InputStream inputStream = this.getStream(4096);
        inputStream.mark(8192);
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            n2 += n;
        }
        try {
            inputStream.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputStream = this.getStream(655360);
        inputStream.mark(131072);
        byArray = new byte[8192];
        while (inputStream.read(byArray, 0, byArray.length) != -1) {
        }
        try {
            inputStream.reset();
            ReaderToUTF8StreamTest.fail((String)"reset-call was expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMarkReadAlmostUntilEOF() throws IOException {
        int n;
        int n2 = 4096;
        InputStream inputStream = this.getStream(n2);
        inputStream.mark(8192);
        byte[] byArray = new byte[n2 * 2];
        for (int i = 0; i < n2 - 1 && (n = inputStream.read(byArray, i, n2 - 1 - i)) != -1; i += n) {
        }
        inputStream.reset();
        this.checkBeginningOfStream(inputStream);
    }

    public void testHeaderPresentInStream_Internal() throws IOException {
        int n = DEFAULT_INTERNAL_BUFFER_SIZE + 5120;
        InputStream inputStream = this.getStream(n);
        inputStream.mark(n - 1024);
        ClobStreamHeaderGenerator clobStreamHeaderGenerator = new ClobStreamHeaderGenerator(false);
        byte[] byArray = new byte[100];
        int n2 = clobStreamHeaderGenerator.generateInto(byArray, 0, (long)n);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byte[] byArray3 = new byte[n2];
        ReaderToUTF8StreamTest.assertEquals((int)n2, (int)inputStream.read(byArray3));
        ReaderToUTF8StreamTest.assertEquals(new ByteArrayInputStream(byArray2), new ByteArrayInputStream(byArray3));
    }

    private InputStream getStream(int n) {
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader((long)n, CharAlphabet.modernLatinLowercase());
        ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream((Reader)loopingAlphabetReader, n, 0, "CLOB", (StreamHeaderGenerator)new ClobStreamHeaderGenerator(false));
        ReaderToUTF8StreamTest.assertTrue((String)"The stream doesn't support mark/reset", (boolean)readerToUTF8Stream.markSupported());
        return readerToUTF8Stream;
    }

    private void checkBeginningOfStream(InputStream inputStream) throws IOException {
        ReaderToUTF8StreamTest.assertEquals((long)5L, (long)inputStream.skip(5L));
        ReaderToUTF8StreamTest.assertEquals((int)97, (int)inputStream.read());
        ReaderToUTF8StreamTest.assertEquals((int)98, (int)inputStream.read());
    }

    private void fillArray(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            ReaderToUTF8StreamTest.assertTrue((String)"reached EOF", (n != -1 ? 1 : 0) != 0);
        }
    }

    public void testRandomSequence() throws IOException {
        long l = System.currentTimeMillis();
        try {
            this.testRandomSequence(l);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("seed=" + l);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    private void testRandomSequence(long l) throws IOException {
        ReaderToUTF8StreamTest.println("testRandomSequence seed: " + l);
        Random random = new Random(l);
        for (int i = 0; i < 100; ++i) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 1024 * random.nextInt(1024) + random.nextInt(1024);
            boolean bl = random.nextBoolean();
            ReaderToUTF8StreamTest.println(">>> iteration " + i + ", length=" + n7);
            int n8 = 0;
            int n9 = 0;
            int n10 = -1;
            InputStream inputStream = this.getStream(n7);
            for (n = 0; n < 200 && n8 < n7 - 10; ++n) {
                if (random.nextBoolean()) {
                    int n11 = this.getRandomLength(n8, n7, random, bl);
                    if (random.nextBoolean()) {
                        this.mytrace("\treading " + n11 + " bytes");
                        ++n2;
                        inputStream.read(new byte[n11]);
                    } else {
                        this.mytrace("\tskipping " + n11 + " bytes");
                        ++n3;
                        inputStream.skip(n11);
                    }
                    if (n10 != -1 && (n8 += n11) - n10 > n9) {
                        this.mytrace("\t\tmark invalidated");
                        ++n6;
                        n10 = -1;
                        n9 = 0;
                    }
                }
                if (!random.nextBoolean() || !random.nextBoolean()) continue;
                if (random.nextInt(100) < 40 && n10 != -1) {
                    this.mytrace("\tresetting to position " + n10);
                    ++n4;
                    inputStream.reset();
                    n8 = n10;
                    n10 = -1;
                    continue;
                }
                n9 = this.getRandomLength(n8, n7, random);
                this.mytrace("\tmarking position " + n8 + " with limit " + n9);
                ++n5;
                n10 = n8;
                inputStream.mark(n9);
            }
            ReaderToUTF8StreamTest.println("ops=" + n + ", reads=" + n2 + ", skips=" + n3 + ", marks=" + n5 + ", resets=" + n4 + ", invalidations=" + n6);
        }
    }

    private int getRandomLength(int n, int n2, Random random) {
        return this.getRandomLength(n, n2, random, false);
    }

    private int getRandomLength(int n, int n2, Random random, boolean bl) {
        int n3 = n2 - n;
        if (bl) {
            n3 /= 5;
        }
        return 1 + (int)((float)n3 * random.nextFloat());
    }

    private void mytrace(String string) {
        if (this.getTestConfiguration().isVerbose()) {
            ReaderToUTF8StreamTest.traceit(string);
        }
    }

    public void testMarkReset1() throws IOException {
        InputStream inputStream = this.getStream(65536);
        byte[] byArray = new byte[65541];
        this.fillArray(inputStream, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        inputStream = this.getStream(65536);
        StreamUtil streamUtil = new StreamUtil(inputStream, byteArrayInputStream);
        streamUtil.mark(1024);
        streamUtil.skip(17L);
        streamUtil.reset();
        streamUtil.read(1);
        streamUtil.read(2133);
        streamUtil.mark(1024);
        streamUtil.reset();
        streamUtil.mark(1024);
        streamUtil.skip(18L);
        streamUtil.read(1024);
    }

    public void testMarkReset2_Internal() throws IOException {
        InputStream inputStream = this.getStream(131072);
        byte[] byArray = new byte[131077];
        this.fillArray(inputStream, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        inputStream = this.getStream(131072);
        StreamUtil streamUtil = new StreamUtil(inputStream, byteArrayInputStream);
        streamUtil.skip(DEFAULT_INTERNAL_BUFFER_SIZE);
        streamUtil.mark(DEFAULT_INTERNAL_BUFFER_SIZE + 2048);
        streamUtil.read(1024);
        streamUtil.reset();
        streamUtil.read(3072);
    }

    private class StreamUtil {
        private final InputStream is1;
        private final InputStream is2;

        StreamUtil(InputStream inputStream, InputStream inputStream2) {
            Assert.assertNotNull((Object)inputStream);
            Assert.assertNotNull((Object)inputStream2);
            this.is1 = inputStream;
            this.is2 = inputStream2;
        }

        public void mark(int n) {
            this.is1.mark(n);
            this.is2.mark(n);
        }

        public void reset() throws IOException {
            this.is1.reset();
            this.is2.reset();
        }

        public long skip(long l) throws IOException {
            long l2;
            long l3;
            long l4 = 0L;
            for (l2 = 0L; l2 < l; l2 += l3) {
                l3 = this.is1.skip(l - l2);
                if (l3 != -1L) continue;
                Assert.fail((String)("stream one reached EOF: " + this.is1.getClass()));
            }
            while (l4 < l) {
                l3 = this.is2.skip(l - l4);
                if (l3 == -1L) {
                    Assert.fail((String)("stream two reached EOF: " + this.is2.getClass()));
                }
                l4 += l3;
            }
            Assert.assertEquals((long)l2, (long)l4);
            return l2;
        }

        public int read(int n) throws IOException {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            int n2 = this.read(byArray, byArray2, false);
            BaseTestCase.assertEquals(new ByteArrayInputStream(byArray), new ByteArrayInputStream(byArray2));
            return n2;
        }

        public int read(byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
            int n;
            int n2;
            Assert.assertEquals((String)"unequal sized arrays", (int)byArray.length, (int)byArray2.length);
            int n3 = 0;
            int n4 = byArray.length;
            for (n = 0; n < n4; n += n2) {
                n2 = this.is1.read(byArray, n, n4 - n);
                if (n2 != -1) continue;
                if (bl) break;
                Assert.fail((String)("stream one reached EOF: " + this.is1.getClass()));
            }
            while (n3 < n4) {
                n2 = this.is2.read(byArray2, n3, n4 - n3);
                if (n2 == -1) {
                    if (bl) break;
                    Assert.fail((String)("stream two reached EOF: " + this.is2.getClass()));
                }
                n3 += n2;
            }
            Assert.assertEquals((int)n, (int)n3);
            return n;
        }
    }
}

