/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimpleTest
extends BaseJDBCTestCase {
    public SimpleTest(String string) {
        super(string);
    }

    public void testBasicOperations() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table b (si smallint,i int, bi bigint, r real, f float, d double precision, n5_2 numeric(5,2), dec10_3 decimal(10,3), ch20 char(20),vc varchar(20), lvc long varchar, blobCol blob(1000),  clobCol clob(1000))");
        statement.executeUpdate(" insert into b values(2,3,4,5.3,5.3,5.3,31.13,123456.123, 'one','one','one',cast(X'01ABCD' as blob(1000)),'one')");
        statement.executeUpdate("insert into b values(-32768,-2147483648, -9223372036854775808 ,1.2E-37, 2.225E-307, +2.225E-307,-56.12, -123456.123,'one','one','one', cast(X'01ABCD' as blob(1000)),'one')");
        statement.executeUpdate(" insert into b values(null,null,null,null,null,null,null,null,null,null,null,null,null)");
        statement.executeUpdate(" insert into b values(32767,2147483647, 9223372036854775807 ,1.4 , 3.4028235E38 ,3.4028235E38  ,999.99, 9999999.999,'one','one','one',cast(X'01ABCD' as blob(1000)), 'one')");
        ResultSet resultSet = statement.executeQuery("select * from b");
        String[][] stringArray = new String[][]{{"2", "3", "4", "5.3", "5.3", "5.3", "31.13", "123456.123", "one                 ", "one", "one", "01abcd", "one"}, {"-32768", "-2147483648", "-9223372036854775808", "1.2E-37", "2.225E-307", "2.225E-307", "-56.12", "-123456.123", "one                 ", "one", "one", "01abcd", "one"}, {null, null, null, null, null, null, null, null, null, null, null, null, null}, {"32767", "2147483647", "9223372036854775807", "1.4", "3.4028235E38", "3.4028235E38", "999.99", "9999999.999", "one                 ", "one", "one", "01abcd", "one"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("drop table b");
        statement.executeUpdate("create table c  (si smallint not null,i int not null , bi bigint not null, r real not null, f float not null, d double precision not null, n5_2 numeric(5,2) not null , dec10_3 decimal(10,3) not null, ch20 char(20) not null ,vc varchar(20) not null, lvc long varchar not null,  blobCol blob(1000) not null,  clobCol clob(1000) not null)");
        statement.executeUpdate("insert into c values(2,3,4,5.3,5.3,5.3,31.13,123456.123, 'one','one','one', cast(X'01ABCD' as blob(1000)), 'one')");
        statement.executeUpdate("insert into c values(-32768,-2147483648, -9223372036854775808 ,1.2E-37, 2.225E-307, +2.225E-307,-56.12, -123456.123,'one','one','one', cast(X'01ABCD' as blob(1000)),'one')");
        resultSet = statement.executeQuery("select * from c");
        stringArray = new String[][]{{"2", "3", "4", "5.3", "5.3", "5.3", "31.13", "123456.123", "one                 ", "one", "one", "01abcd", "one"}, {"-32768", "-2147483648", "-9223372036854775808", "1.2E-37", "2.225E-307", "2.225E-307", "-56.12", "-123456.123", "one                 ", "one", "one", "01abcd", "one"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("drop table c");
        resultSet = statement.executeQuery("values ( 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84)");
        stringArray = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("values(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,91, 92, 93, 94, 95, 96, 97, 98, 99, 100)");
        stringArray = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        connection.setAutoCommit(false);
        statement.executeUpdate("create table a (a int)");
        statement.executeUpdate("insert into a values(1)");
        resultSet = statement.executeQuery("select * from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        connection.commit();
        statement.executeUpdate("drop table a");
        connection.rollback();
        resultSet = statement.executeQuery("select * from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        statement.executeUpdate("drop table a");
        connection.commit();
    }

    public void testBugFixes() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select aliasinfo from sys.sysaliases where aliasinfo is null");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("create table a (a int)");
        SimpleTest.assertStatementError("22003", statement, "insert into a values(2342323423)");
        statement.executeUpdate("drop table a");
        connection.setAutoCommit(false);
        statement.executeUpdate("create table t (i int)");
        statement.executeUpdate("insert into t values(1)");
        connection.commit();
        statement.executeUpdate("insert into t values(2)");
        connection.setHoldability(2);
        Connection connection2 = this.openDefaultConnection();
        PreparedStatement preparedStatement = connection2.prepareStatement("select * from t");
        SimpleTest.assertStatementError("40XL1", preparedStatement);
        SimpleTest.assertStatementError("40XL1", preparedStatement);
        Statement statement2 = connection2.createStatement();
        statement2.executeUpdate("create table t1 (c1 clob(10), c2 clob(10))");
        statement2.executeUpdate("insert into t1 values ('', 'some clob')");
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"", "some clob"}});
        resultSet = statement2.executeQuery("select c2 from t1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"some clob"}});
        statement2.executeUpdate("drop table t1");
        connection2.commit();
        statement2.close();
        preparedStatement.close();
        connection2.close();
        statement.executeUpdate("drop table t");
        statement.close();
        connection.commit();
        connection.close();
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(SimpleTest.class);
        return DatabasePropertyTestSetup.setLockTimeouts(test, 3, 3);
    }
}

