/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SpecialFlags {
    public static Properties getSpecialProperties(Properties suiteProperties) {
        String[] excludeList = new String[]{"jvm", "classpath", "classpathServer", "framework", "usesystem", "useprocess", "outputdir", "replication", "keepfiles", "mtestdir", "suites", "searchCP", "useoutput", "suitename", "cleanfiles", "systemdiff", "jvmflags", "testJavaFlags", "ij.defaultResourcePackage", "outcopy", "verbose", "canondir", "timeout", "encryption", "javaCmd", "topreportdir", "jarfile", "upgradetest", "jdk12test", "jdk12exttest", "skipsed", "sourceEnv"};
        Properties p = new Properties();
        Enumeration<?> e = suiteProperties.propertyNames();
        while (e.hasMoreElements()) {
            boolean exclude = false;
            String key = (String)e.nextElement();
            for (int i = 0; i < excludeList.length; ++i) {
                if (!excludeList[i].equals(key)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            String value = suiteProperties.getProperty(key);
            p.put(key, value);
        }
        return p;
    }

    public static void parse(String flags, Properties ijProps, Properties srvProps) {
        if (flags == null) {
            flags = "";
        }
        StringTokenizer st = new StringTokenizer(flags, "^");
        String str = "";
        String key = "";
        String value = "";
        while (st.hasMoreTokens()) {
            str = st.nextToken();
            key = str.substring(0, str.indexOf("="));
            value = str.substring(str.indexOf("=") + 1);
            if (str.startsWith("derby")) {
                String currval;
                if ((key.equals("derby.debug.true") || key.equals("derby.infolog.streams")) && (currval = srvProps.getProperty(key)) != null && currval.length() > 0) {
                    value = value + "," + currval;
                }
                srvProps.put(key, value);
                continue;
            }
            ijProps.put(key, value);
        }
    }

    private SpecialFlags() {
    }
}

