/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.JaccardSimilarity;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JaccardSimilarityTest {
    @Test
    public void checkNullCombinations() throws IOException {
        JaccardSimilarity jaccardFunc = new JaccardSimilarity();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(2);
        Tuple resultTuple = (Tuple)jaccardFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        for (Object d : resultTuple.getAll()) {
            Assert.assertEquals(d, (Object)0.0);
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(1, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 128));
        resultTuple = (Tuple)jaccardFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        for (Object d : resultTuple.getAll()) {
            Assert.assertEquals(d, (Object)0.0);
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 256));
        resultTuple = (Tuple)jaccardFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        for (Object d : resultTuple.getAll()) {
            Assert.assertEquals(d, (Object)0.0);
        }
        inputTuple = TupleFactory.getInstance().newTuple(2);
        inputTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 256));
        inputTuple.set(1, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 128));
        resultTuple = (Tuple)jaccardFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)0.5);
        Assert.assertEquals((Object)resultTuple.get(1), (Object)0.5);
        Assert.assertEquals((Object)resultTuple.get(2), (Object)0.5);
    }
}

