/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.throttling.ThrottlingInterceptor;
import org.apache.cxf.throttling.ThrottlingManager;
import org.apache.cxf.throttling.ThrottlingResponseInterceptor;

public class ThrottlingFeature
extends DelegatingFeature<Portable> {
    public ThrottlingFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public ThrottlingFeature(ThrottlingManager manager) {
        super((AbstractPortableFeature)new Portable(manager));
    }

    public static class Portable
    implements AbstractPortableFeature {
        final ThrottlingManager manager;

        public Portable() {
            this.manager = null;
        }

        public Portable(ThrottlingManager manager) {
            this.manager = manager;
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            ThrottlingManager m = this.manager;
            if (m == null) {
                m = (ThrottlingManager)bus.getExtension(ThrottlingManager.class);
            }
            if (m == null) {
                throw new IllegalArgumentException("ThrottlingManager must not be null");
            }
            for (String p : m.getDecisionPhases()) {
                provider.getInInterceptors().add(new ThrottlingInterceptor(p, m));
            }
            provider.getOutInterceptors().add(new ThrottlingResponseInterceptor());
            provider.getOutFaultInterceptors().add(new ThrottlingResponseInterceptor());
        }
    }
}

