/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.utils.JsonLoader;

public class Role
implements Serializable {
    private static final long serialVersionUID = 3560097227776448872L;
    private String name;
    private boolean send;
    private boolean consume;
    private boolean createAddress;
    private boolean deleteAddress;
    private boolean createDurableQueue;
    private boolean deleteDurableQueue;
    private boolean createNonDurableQueue;
    private boolean deleteNonDurableQueue;
    private boolean manage;
    private boolean browse;
    private boolean view;
    private boolean edit;

    public JsonObject toJson() {
        return JsonLoader.createObjectBuilder().add("name", this.name).add("send", this.send).add("consume", this.consume).add("createDurableQueue", this.createDurableQueue).add("deleteDurableQueue", this.deleteDurableQueue).add("createNonDurableQueue", this.createNonDurableQueue).add("deleteNonDurableQueue", this.deleteNonDurableQueue).add("manage", this.manage).add("browse", this.browse).add("createAddress", this.createAddress).add("deleteAddress", this.deleteAddress).add("view", this.view).add("edit", this.edit).build();
    }

    public Role() {
    }

    @Deprecated
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, consume);
    }

    @Deprecated
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, browse, createDurableQueue || createNonDurableQueue, deleteDurableQueue || deleteNonDurableQueue, false, false);
    }

    @Deprecated
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse, boolean createAddress, boolean deleteAddress) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, browse, createAddress, deleteAddress, false, false);
    }

    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse, boolean createAddress, boolean deleteAddress, boolean view, boolean edit) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.send = send;
        this.consume = consume;
        this.createAddress = createAddress;
        this.deleteAddress = deleteAddress;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
        this.browse = browse;
        this.view = view;
        this.edit = edit;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateAddress() {
        return this.createAddress;
    }

    public boolean isDeleteAddress() {
        return this.deleteAddress;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public boolean isManage() {
        return this.manage;
    }

    public boolean isBrowse() {
        return this.browse;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSend(boolean send) {
        this.send = send;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public void setCreateAddress(boolean createAddress) {
        this.createAddress = createAddress;
    }

    public void setDeleteAddress(boolean deleteAddress) {
        this.deleteAddress = deleteAddress;
    }

    public void setCreateDurableQueue(boolean createDurableQueue) {
        this.createDurableQueue = createDurableQueue;
    }

    public void setDeleteDurableQueue(boolean deleteDurableQueue) {
        this.deleteDurableQueue = deleteDurableQueue;
    }

    public void setCreateNonDurableQueue(boolean createNonDurableQueue) {
        this.createNonDurableQueue = createNonDurableQueue;
    }

    public void setDeleteNonDurableQueue(boolean deleteNonDurableQueue) {
        this.deleteNonDurableQueue = deleteNonDurableQueue;
    }

    public void setManage(boolean manage) {
        this.manage = manage;
    }

    public void setBrowse(boolean browse) {
        this.browse = browse;
    }

    public String toString() {
        StringBuilder stringReturn = new StringBuilder("Role {name=" + this.name + "; allows=[");
        if (this.send) {
            stringReturn.append(" send ");
        }
        if (this.consume) {
            stringReturn.append(" consume ");
        }
        if (this.createAddress) {
            stringReturn.append(" createAddress ");
        }
        if (this.deleteAddress) {
            stringReturn.append(" deleteAddress ");
        }
        if (this.createDurableQueue) {
            stringReturn.append(" createDurableQueue ");
        }
        if (this.deleteDurableQueue) {
            stringReturn.append(" deleteDurableQueue ");
        }
        if (this.createNonDurableQueue) {
            stringReturn.append(" createNonDurableQueue ");
        }
        if (this.deleteNonDurableQueue) {
            stringReturn.append(" deleteNonDurableQueue ");
        }
        if (this.manage) {
            stringReturn.append(" manage ");
        }
        if (this.browse) {
            stringReturn.append(" browse ");
        }
        if (this.view) {
            stringReturn.append(" view ");
        }
        if (this.edit) {
            stringReturn.append(" edit ");
        }
        stringReturn.append("]}");
        return stringReturn.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.name, other.name) && this.send == other.send && this.consume == other.consume && this.createAddress == other.createAddress && this.deleteAddress == other.deleteAddress && this.createDurableQueue == other.createDurableQueue && this.createNonDurableQueue == other.createNonDurableQueue && this.deleteDurableQueue == other.deleteDurableQueue && this.deleteNonDurableQueue == other.deleteNonDurableQueue && this.manage == other.manage && this.browse == other.browse && this.view == other.view && this.edit == other.edit;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.send, this.consume, this.createAddress, this.deleteAddress, this.createDurableQueue, this.deleteDurableQueue, this.createNonDurableQueue, this.deleteNonDurableQueue, this.manage, this.browse, this.view, this.edit);
    }

    public void merge(Role other) {
        this.send = this.send || other.send;
        this.consume = this.consume || other.consume;
        this.createAddress = this.createAddress || other.createAddress;
        this.deleteAddress = this.deleteAddress || other.deleteAddress;
        this.createDurableQueue = this.createDurableQueue || other.createDurableQueue;
        this.deleteDurableQueue = this.deleteDurableQueue || other.deleteDurableQueue;
        this.createNonDurableQueue = this.createNonDurableQueue || other.createNonDurableQueue;
        this.deleteNonDurableQueue = this.deleteNonDurableQueue || other.deleteNonDurableQueue;
        this.manage = this.manage || other.manage;
        this.browse = this.browse || other.browse;
        this.view = this.view || other.view;
        this.edit = this.edit || other.edit;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }
}

