/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.archive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.ehcache.shadow.org.terracotta.statistics.Sample;
import org.ehcache.shadow.org.terracotta.statistics.archive.CircularBuffer;

public class StatisticArchive<T extends Serializable> {
    private static final Comparator<Sample<?>> TIMESTAMPED_COMPARATOR = Comparator.comparingLong(Sample::getTimestamp);
    private final Consumer<? super Sample<T>> overspill;
    private volatile int size;
    private volatile CircularBuffer<Sample<T>> buffer;

    public StatisticArchive(int size) {
        this(size, sample -> {});
    }

    public StatisticArchive(int size, Consumer<? super Sample<T>> overspill) {
        this.size = size;
        this.overspill = overspill;
    }

    public synchronized void setCapacity(int samples) {
        if (samples != this.size) {
            this.size = samples;
            if (this.buffer != null) {
                CircularBuffer<Sample<T>> newBuffer = new CircularBuffer<Sample<T>>(this.size);
                for (Sample<T> sample : this.getArchive()) {
                    this.overspill.accept(newBuffer.insert(sample));
                }
                this.buffer = newBuffer;
            }
        }
    }

    public synchronized void add(Sample<T> object) {
        if (this.buffer == null) {
            this.buffer = new CircularBuffer(this.size);
        }
        this.overspill.accept(this.buffer.insert(object));
    }

    public synchronized void clear() {
        this.buffer = null;
    }

    public List<Sample<T>> getArchive() {
        CircularBuffer<Sample<T>> read = this.buffer;
        if (read == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(read.toArray(Sample[].class)));
    }

    public List<Sample<T>> getArchive(long since) {
        CircularBuffer<Sample<T>> read = this.buffer;
        if (read == null) {
            return Collections.emptyList();
        }
        Sample<Object> e = new Sample<Object>(since, null);
        Sample[] array = (Sample[])read.toArray(Sample[].class);
        int pos = Arrays.binarySearch(array, e, TIMESTAMPED_COMPARATOR);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos >= array.length) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(Arrays.copyOfRange(array, pos, array.length)));
    }
}

